/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.BloodLine;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LineRenderer<T extends BloodLine>
extends EntityRenderer<T> {
    public LineRenderer(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public void render(T entity, float p_114486_, float p_114487_, PoseStack poseStack, MultiBufferSource bufferSource, int p_114490_) {
        double x = Mth.lerp((double)p_114487_, (double)((BloodLine)((Object)entity)).xOld, (double)entity.getX());
        double y = Mth.lerp((double)p_114487_, (double)((BloodLine)((Object)entity)).yOld, (double)entity.getY());
        double z = Mth.lerp((double)p_114487_, (double)((BloodLine)((Object)entity)).zOld, (double)entity.getZ());
        poseStack.pushPose();
        poseStack.translate(entity.getX() - x, entity.getY() - y, entity.getZ() - z);
        this.setT(poseStack, entity, bufferSource);
        poseStack.popPose();
        super.render(entity, p_114486_, p_114487_, poseStack, bufferSource, p_114490_);
    }

    private void setT(PoseStack matrices, T entity, MultiBufferSource vertexConsumers) {
        matrices.pushPose();
        for (int i = 1; i < ((BloodLine)((Object)entity)).getTrailPositions().size(); ++i) {
            Vec3 prevPos = ((BloodLine)((Object)entity)).getTrailPositions().get(i - 1);
            Vec3 currPos = ((BloodLine)((Object)entity)).getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getX(), prevPos.y - entity.getY(), prevPos.z - entity.getZ());
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getX(), currPos.y - entity.getY(), currPos.z - entity.getZ());
            float alpha = (float)i / (float)((BloodLine)((Object)entity)).getTrailPositions().size();
            Handler.renderLine(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, RenderType.lightning(), 0.05f);
        }
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation(T p_114482_) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/entity/flysword.png");
    }
}

