/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.client.zombie;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.moonstone.moonstonemod.entity.client.zombie.GModel;
import com.moonstone.moonstonemod.entity.zombie.CellGiant;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GEmissiveLay<T extends CellGiant, M extends GModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;
    private final RenderType renderType;

    public GEmissiveLay(RenderLayerParent<T, M> p_234885_, ResourceLocation p_234886_, AlphaFunction<T> p_234887_, DrawSelector<T, M> p_234888_, RenderType renderType) {
        super(p_234885_);
        this.texture = p_234886_;
        this.alphaFunction = p_234887_;
        this.drawSelector = p_234888_;
        this.renderType = renderType;
    }

    public void render(PoseStack p_234902_, MultiBufferSource p_234903_, int p_234904_, T p_234905_, float p_234906_, float p_234907_, float p_234908_, float p_234909_, float p_234910_, float p_234911_) {
        if (!p_234905_.isInvisible()) {
            this.onlyDrawSelectedParts();
            float f = this.alphaFunction.apply(p_234905_, p_234908_, p_234909_);
            int i = FastColor.ARGB32.color((int)Mth.floor((float)(f * 255.0f)), (int)255, (int)255, (int)255);
            VertexConsumer vertexconsumer = this.renderType != null ? p_234903_.getBuffer(this.renderType) : p_234903_.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)this.texture));
            ((GModel)this.getParentModel()).renderToBuffer(p_234902_, vertexconsumer, p_234904_, LivingEntityRenderer.getOverlayCoords(p_234905_, (float)0.0f), i);
            this.resetDrawForAllParts();
        }
    }

    private void onlyDrawSelectedParts() {
        List<ModelPart> list = this.drawSelector.getPartsToDraw((GModel)this.getParentModel());
        ((GModel)this.getParentModel()).root().getAllParts().forEach(p_234918_ -> {
            p_234918_.skipDraw = true;
        });
        list.forEach(p_234916_ -> {
            p_234916_.skipDraw = false;
        });
    }

    private void resetDrawForAllParts() {
        ((GModel)this.getParentModel()).root().getAllParts().forEach(p_234913_ -> {
            p_234913_.skipDraw = false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<T extends CellGiant> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<T extends CellGiant, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

