/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.nightmare.ai;

import com.google.common.collect.ImmutableMap;
import com.moonstone.moonstonemod.entity.nightmare.NightmareGiant;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;

public class SonicBoom
extends Behavior<NightmareGiant> {
    private static final int DISTANCE_XZ = 15;
    private static final int DISTANCE_Y = 20;
    private static final double KNOCKBACK_VERTICAL = 0.5;
    private static final double KNOCKBACK_HORIZONTAL = 2.5;
    public static final int COOLDOWN = 40;
    private static final int TICKS_BEFORE_PLAYING_SOUND = Mth.ceil((double)34.0);
    private static final int DURATION = Mth.ceil((float)60.0f);

    public SonicBoom() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.SONIC_BOOM_SOUND_DELAY, (Object)MemoryStatus.REGISTERED), DURATION);
    }

    protected boolean checkExtraStartConditions(ServerLevel p_217692_, NightmareGiant p_217693_) {
        return p_217693_.closerThan((Entity)p_217693_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get(), 15.0, 20.0);
    }

    protected boolean canStillUse(ServerLevel p_217695_, NightmareGiant p_217696_, long p_217697_) {
        return true;
    }

    protected void start(ServerLevel p_217713_, NightmareGiant p_217714_, long p_217715_) {
        p_217714_.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)DURATION);
        p_217714_.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_DELAY, (Object)Unit.INSTANCE, (long)TICKS_BEFORE_PLAYING_SOUND);
        p_217713_.broadcastEntityEvent((Entity)p_217714_, (byte)62);
        p_217714_.playSound(SoundEvents.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
    }

    protected void tick(ServerLevel p_217724_, NightmareGiant p_217725_, long p_217726_) {
        p_217725_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(p_289393_ -> p_217725_.getLookControl().setLookAt(p_289393_.position()));
        p_217725_.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, (Object)Unit.INSTANCE, (long)(DURATION - TICKS_BEFORE_PLAYING_SOUND));
        p_217725_.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).filter(p_217707_ -> p_217725_.closerThan((Entity)p_217707_, 15.0, 20.0)).ifPresent(p_217704_ -> {
            if (p_217704_.isAlive() && p_217725_.tickCount % 10 == 1) {
                Vec3 vec3 = p_217725_.position().add(0.0, (double)1.6f, 0.0);
                Vec3 vec31 = p_217704_.getEyePosition().subtract(vec3);
                Vec3 vec32 = vec31.normalize();
                p_217725_.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.0f);
                p_217704_.hurt(p_217724_.damageSources().sonicBoom((Entity)p_217725_), 20.0f);
                p_217704_.invulnerableTime = 0;
                double d1 = 0.5 * (1.0 - p_217704_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                double d0 = 2.5 * (1.0 - p_217704_.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                p_217704_.push(vec32.x() * d0, vec32.y() * d1, vec32.z() * d0);
            }
        });
    }

    protected void stop(ServerLevel p_217732_, NightmareGiant p_217733_, long p_217734_) {
        SonicBoom.setCooldown((LivingEntity)p_217733_, 40);
    }

    public static void setCooldown(LivingEntity p_217699_, int p_217700_) {
        p_217699_.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)Unit.INSTANCE, (long)p_217700_);
    }
}

