/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.zombie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moonstone.moonstonemod.entity.ai.AIgiant;
import com.moonstone.moonstonemod.entity.extend.MoonTamableAnimal;
import com.moonstone.moonstonemod.entity.nightmare.ai.AInightmare;
import com.moonstone.moonstonemod.entity.nightmare.ai.SonicBoom;
import com.moonstone.moonstonemod.entity.zombie.CellZombie;
import com.moonstone.moonstonemod.init.other.EntityTs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class CellGiant
extends MoonTamableAnimal
implements OwnableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.defineId(CellGiant.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int tendrilAnimation;
    private int tendrilAnimationO;
    private int heartAnimation;
    private int heartAnimationO;
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState sniffAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private VibrationSystem.Data vibrationData;
    AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public CellGiant(EntityType<? extends CellGiant> p_219350_, Level p_219351_) {
        super(p_219350_, p_219351_);
        this.vibrationData = new VibrationSystem.Data();
        this.xpReward = 5;
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352154_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352154_, this.hasPose(Pose.EMERGING) ? 1 : 0);
    }

    @Override
    public void die(@NotNull DamageSource p_21809_) {
        super.die(p_21809_);
        if (this.getTags().contains("Parasitic_cell_Giant")) {
            for (int i = 0; i < 6; ++i) {
                CellZombie cell_zombie = new CellZombie((EntityType<? extends CellZombie>)((EntityType)EntityTs.cell_zombie.get()), this.level());
                cell_zombie.setPos(this.getX(), this.getY(), this.getY());
                if (this.getOwnerUUID() != null) {
                    cell_zombie.setOwnerUUID(this.getOwnerUUID());
                }
                this.level().addFreshEntity((Entity)cell_zombie);
            }
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> AttributeModifier(CellGiant cellGiant, LivingEntity living) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (cellGiant.getTags().contains("Bone_Giant")) {
            modifierMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagecell_armor"), living.getAttributeValue(Attributes.ARMOR) * 0.7, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifierMultimap;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_219420_) {
        super.recreateFromPacket(p_219420_);
        if (p_219420_.getData() == 1) {
            this.setPose(Pose.EMERGING);
        }
    }

    public boolean checkSpawnObstruction(LevelReader p_219398_) {
        return super.checkSpawnObstruction(p_219398_) && p_219398_.noCollision((Entity)this, this.getType().getDimensions().makeBoundingBox(this.position()));
    }

    public float getWalkTargetValue(BlockPos p_219410_, LevelReader p_219411_) {
        return 0.0f;
    }

    boolean isDiggingOrEmerging() {
        return this.hasPose(Pose.DIGGING) || this.hasPose(Pose.EMERGING);
    }

    protected boolean canRide(Entity p_219462_) {
        return false;
    }

    public boolean canDisableShield() {
        return true;
    }

    protected float nextStep() {
        return this.moveDist + 0.55f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.ATTACK_DAMAGE, 10.0);
    }

    public boolean dampensVibrations() {
        return true;
    }

    protected float getSoundVolume() {
        return 4.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return !this.hasPose(Pose.ROARING) && !this.isDiggingOrEmerging() ? this.getAngerLevel().getAmbientSound() : null;
    }

    protected SoundEvent getHurtSound(DamageSource p_219440_) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    protected void playStepSound(BlockPos p_219431_, BlockState p_219432_) {
        this.playSound(SoundEvents.ZOMBIE_STEP, 1.0f, 1.0f);
    }

    @Override
    public boolean doHurtTarget(Entity p_219472_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        SonicBoom.setCooldown((LivingEntity)this, 40);
        return super.doHurtTarget(p_219472_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.entityData.get(CLIENT_ANGER_LEVEL);
    }

    private void syncClientAngerLevel() {
        this.entityData.set(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    @Override
    public void tick() {
        ResourceLocation entity;
        Level level;
        LivingEntity livingEntity;
        ++this.time;
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 22) {
            this.trailPositions.removeFirst();
        }
        if ((livingEntity = this.getOwner()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.getAttributes().addTransientAttributeModifiers(this.AttributeModifier(this, (LivingEntity)player));
        }
        this.time = !this.getTags().contains("Disgusting__cell_Giant") ? (this.time += 2) : ++this.time;
        if (this.time > 2400) {
            this.kill();
        }
        if (this.getOwner() != null) {
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtByMob().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastHurtByMob());
                this.setTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastAttacker().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastAttacker());
                this.setTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtMob().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastHurtMob());
                this.setTarget(this.getOwner().getLastHurtMob());
            }
        }
        if ((level = this.level()) instanceof ServerLevel && (this.isPersistenceRequired() || this.requiresCustomPersistence())) {
            AInightmare.setDigCooldown((LivingEntity)this);
        }
        super.tick();
        if (this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() && (entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((LivingEntity)this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get()).getType())).getNamespace().equals("moonstone")) {
            this.setAttackTarget(null);
        }
        this.setAttackT();
        if (this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent()) {
            if (!((LivingEntity)this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get()).isAlive()) {
                this.setAttackTarget(null);
            } else {
                Object t = this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
                if (t instanceof OwnableEntity) {
                    entity = (OwnableEntity)t;
                    if (this.getOwner() != null && entity.getOwner() != null && entity.getOwner().is((Entity)this.getOwner())) {
                        this.setAttackTarget(null);
                        this.setTarget(null);
                    }
                }
            }
        }
        if (this.level().isClientSide()) {
            if (this.tickCount % this.getHeartBeatDelay() == 0) {
                this.heartAnimation = 10;
                if (!this.isSilent()) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WARDEN_HEARTBEAT, this.getSoundSource(), 1.0f, this.getVoicePitch(), false);
                }
            }
            this.tendrilAnimationO = this.tendrilAnimation;
            if (this.tendrilAnimation > 0) {
                --this.tendrilAnimation;
            }
            this.heartAnimationO = this.heartAnimation;
            if (this.heartAnimation > 0) {
                --this.heartAnimation;
            }
            switch (this.getPose()) {
                case EMERGING: {
                    this.clientDiggingParticles(this.emergeAnimationState);
                    break;
                }
                case DIGGING: {
                    this.clientDiggingParticles(this.diggingAnimationState);
                }
            }
        }
    }

    private void setAttackT() {
    }

    protected void customServerAiStep() {
        ServerLevel serverlevel = (ServerLevel)this.level();
        serverlevel.getProfiler().push("nightmare_giantBrain");
        this.getBrain().tick(serverlevel, (LivingEntity)this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
        if (this.tickCount % 20 == 0) {
            this.angerManagement.tick(serverlevel, this::canTargetEntity);
            this.syncClientAngerLevel();
        }
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.roarAnimationState.stop();
            this.attackAnimationState.start(this.tickCount);
        } else if (p_219360_ == 61) {
            this.tendrilAnimation = 10;
        } else if (p_219360_ == 62) {
            this.sonicBoomAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    private int getHeartBeatDelay() {
        float f = (float)this.getClientAngerLevel() / (float)AngerLevel.ANGRY.getMinimumAnger();
        return 40 - Mth.floor((float)(Mth.clamp((float)f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public float getTendrilAnimation(float p_219468_) {
        return Mth.lerp((float)p_219468_, (float)this.tendrilAnimationO, (float)this.tendrilAnimation) / 10.0f;
    }

    public float getHeartAnimation(float p_219470_) {
        return Mth.lerp((float)p_219470_, (float)this.heartAnimationO, (float)this.heartAnimation) / 10.0f;
    }

    private void clientDiggingParticles(AnimationState p_219384_) {
        if ((float)p_219384_.getAccumulatedTime() < 4500.0f) {
            RandomSource randomsource = this.getRandom();
            BlockState blockstate = this.getBlockStateOn();
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.getX() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    double d1 = this.getY();
                    double d2 = this.getZ() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_219422_) {
        if (DATA_POSE.equals(p_219422_)) {
            switch (this.getPose()) {
                case EMERGING: {
                    this.emergeAnimationState.start(this.tickCount);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.start(this.tickCount);
                    break;
                }
                case ROARING: {
                    this.roarAnimationState.start(this.tickCount);
                    break;
                }
                case SNIFFING: {
                    this.sniffAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_219422_);
    }

    protected Brain<?> makeBrain(Dynamic<?> p_219406_) {
        return AIgiant.makeBrain(this, p_219406_);
    }

    public Brain<CellGiant> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.getOwner() != null && !livingentity.is((Entity)this.getOwner()) && this.level() == p_219386_.level() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(p_219386_) && !this.isAlliedTo(p_219386_) && livingentity.getType() != EntityType.ARMOR_STAND && livingentity.getType() != this.getType() && !livingentity.isInvulnerable() && !livingentity.isDeadOrDying() && this.level().getWorldBorder().isWithinBounds(livingentity.getBoundingBox())) {
                return true;
            }
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag p_219434_) {
        super.addAdditionalSaveData(p_219434_);
        AngerManagement.codec(this::canTargetEntity).encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.angerManagement).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219437_ -> p_219434_.put("anger", p_219437_));
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219418_ -> p_219434_.put("listener", p_219418_));
    }

    public void readAdditionalSaveData(CompoundTag p_219415_) {
        super.readAdditionalSaveData(p_219415_);
        if (p_219415_.contains("anger")) {
            AngerManagement.codec(this::canTargetEntity).parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_219415_.get("anger"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219394_ -> {
                this.angerManagement = p_219394_;
            });
            this.syncClientAngerLevel();
        }
        if (p_219415_.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_219415_.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_281093_ -> {
                this.vibrationData = p_281093_;
            });
        }
    }

    private void playListeningSound() {
        if (!this.hasPose(Pose.ROARING)) {
            this.playSound(this.getAngerLevel().getListeningSound(), 10.0f, this.getVoicePitch());
        }
    }

    public AngerLevel getAngerLevel() {
        return AngerLevel.byAnger((int)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.getActiveAnger((Entity)this.getTarget());
    }

    public void clearAnger(Entity p_219429_) {
        this.angerManagement.clearAnger(p_219429_);
    }

    public void increaseAngerAt(@Nullable Entity p_219442_) {
        this.increaseAngerAt(p_219442_, 35, true);
    }

    @VisibleForTesting
    public void increaseAngerAt(@Nullable Entity p_219388_, int p_219389_, boolean p_219390_) {
        if (!this.isNoAi() && this.canTargetEntity(p_219388_)) {
            AInightmare.setDigCooldown((LivingEntity)this);
            boolean flag = !(this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null) instanceof Player);
            int i = this.angerManagement.increaseAnger(p_219388_, p_219389_);
            if (p_219388_ instanceof Player && flag && AngerLevel.byAnger((int)i).isAngry()) {
                this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            }
            if (p_219390_) {
                this.playListeningSound();
            }
        }
    }

    public Optional<LivingEntity> getEntityAngryAt() {
        return this.getAngerLevel().isAngry() ? this.angerManagement.getActiveEntity() : Optional.empty();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public boolean removeWhenFarAway(double p_219457_) {
        return false;
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        UUID uuid;
        CellGiant wolf = (CellGiant)((EntityType)EntityTs.cell_giant.get()).create((Level)p_146743_);
        if (wolf != null && (uuid = this.getOwnerUUID()) != null) {
            wolf.setOwnerUUID(uuid);
        }
        return wolf;
    }

    public boolean hurt(DamageSource p_219381_, float p_219382_) {
        boolean flag = super.hurt(p_219381_, p_219382_);
        if (!(this.level().isClientSide || this.isNoAi() || this.isDiggingOrEmerging())) {
            Entity entity = p_219381_.getEntity();
            this.increaseAngerAt(entity, AngerLevel.ANGRY.getMinimumAnger() + 20, false);
            if (this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).isEmpty() && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!(p_219381_.isDirect() && !this.closerThan((Entity)livingentity, 5.0) || this.getOwner() == null || livingentity.is((Entity)this.getOwner()))) {
                    this.setAttackTarget(livingentity);
                }
            }
        }
        return flag;
    }

    public void setAttackTarget(LivingEntity p_219460_) {
        if (p_219460_ instanceof OwnableEntity) {
            OwnableEntity entity = (OwnableEntity)p_219460_;
            if (this.getOwner() != null && entity.getOwner() != null && entity.getOwner().is((Entity)this.getOwner())) {
                return;
            }
        }
        if (this.getOwner() != null && p_219460_ != null && !p_219460_.is((Entity)this.getOwner())) {
            this.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
            this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)p_219460_);
            this.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            SonicBoom.setCooldown((LivingEntity)this, 20);
        }
    }

    public boolean isPushable() {
        return !this.isDiggingOrEmerging() && super.isPushable();
    }

    protected void doPush(Entity p_219353_) {
        if (!this.isNoAi() && !this.getBrain().hasMemoryValue(MemoryModuleType.TOUCH_COOLDOWN)) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.TOUCH_COOLDOWN, (Object)Unit.INSTANCE, 20L);
            this.increaseAngerAt(p_219353_);
        }
        super.doPush(p_219353_);
    }

    @VisibleForTesting
    public AngerManagement getAngerManagement() {
        return this.angerManagement;
    }

    protected PathNavigation createNavigation(Level p_219396_) {
        return new GroundPathNavigation(this, (Mob)this, p_219396_){

            protected PathFinder createPathFinder(int p_219479_) {
                this.nodeEvaluator = new WalkNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                return new PathFinder(this, this.nodeEvaluator, p_219479_){

                    protected float distance(Node p_219486_, Node p_219487_) {
                        return p_219486_.distanceToXZ(p_219487_);
                    }
                };
            }
        };
    }
}

