/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.event.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.event.BookEvt;
import com.moonstone.moonstonemod.init.items.BookItems;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.items.moonstoneitem.extend.ManDNA;
import com.moonstone.moonstonemod.init.items.moonstoneitem.i.Iplague;
import com.moonstone.moonstonemod.init.other.DataReg;
import com.moonstone.moonstonemod.init.other.Enchants;
import com.moonstone.moonstonemod.init.other.LootReg;
import com.moonstone.moonstonemod.item.blood.magic.TheBloodBook;
import com.moonstone.moonstonemod.item.man.GreedDna;
import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.event.old.AdvancementEvt;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DungeonLoot
extends LootModifier {
    public static final Supplier<MapCodec<DungeonLoot>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> DungeonLoot.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DungeonLoot::new)));

    protected DungeonLoot(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)LootReg.TD.get();
    }

    private void addLoot(ObjectArrayList<ItemStack> generatedLoot, Random random, Item mustHas, Entity entity, List<Item> itemList, int gLvl) {
        Player player;
        if (entity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)entity), mustHas)) {
            int i = random.nextInt(itemList.size());
            if (gLvl >= 100) {
                gLvl = 100;
            }
            if (Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) <= gLvl) {
                generatedLoot.add((Object)new ItemStack((ItemLike)itemList.get(i)));
            }
        }
    }

    private void addLootHasB(ObjectArrayList<ItemStack> generatedLoot, Random random, boolean a, List<Item> itemList, int gLvl) {
        if (a) {
            int i = random.nextInt(itemList.size());
            if (gLvl >= 100) {
                gLvl = 100;
            }
            if (Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) <= gLvl) {
                generatedLoot.add((Object)new ItemStack((ItemLike)itemList.get(i)));
            }
        }
    }

    public void give(ObjectArrayList<ItemStack> generatedLoot, Entity entity, int lv, String name, Item must, Item give) {
        Player player;
        if (entity instanceof Player && com.ytgld.seeking_immortals.Handler.hascurio((LivingEntity)(player = (Player)entity), must)) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (!stack.is(must) || Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) > lv || stack.get(com.ytgld.seeking_immortals.init.DataReg.tag) == null || ((CompoundTag)stack.get(com.ytgld.seeking_immortals.init.DataReg.tag)).getBoolean(name)) continue;
                        generatedLoot.add((Object)new ItemStack((ItemLike)give));
                        ((CompoundTag)stack.get(com.ytgld.seeking_immortals.init.DataReg.tag)).putBoolean(name, true);
                    }
                }
            });
        }
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player player;
        ResourceLocation s = context.getQueriedLootTableId();
        String idSting = String.valueOf(s);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        Random random = new Random();
        if (((Boolean)Config.SERVER.doLootTableForTwilightForest.get()).booleanValue() && idSting.contains("chests/") && idSting.contains("twilightforest") && idSting.contains("hill")) {
            this.addLoot(generatedLoot, random, (Item)Items.blood_candle.get(), entity, List.of((Item)Items.owner_blood_eye.get(), (Item)Items.owner_blood_attack_eye.get(), (Item)Items.owner_blood_speed_eye.get(), (Item)Items.owner_blood_effect_eye.get(), (Item)Items.owner_blood_boom_eye.get(), (Item)Items.owner_blood_vex.get(), (Item)Items.owner_blood_earth.get()), 15);
        }
        if (idSting.contains("chests/") && idSting.contains("ancient")) {
            this.addLoot(generatedLoot, random, (Item)Items.blood_candle.get(), entity, List.of((Item)Items.owner_blood_eye.get(), (Item)Items.owner_blood_attack_eye.get(), (Item)Items.owner_blood_speed_eye.get(), (Item)Items.owner_blood_effect_eye.get(), (Item)Items.owner_blood_boom_eye.get(), (Item)Items.owner_blood_vex.get(), (Item)Items.owner_blood_earth.get()), 15);
        }
        if (idSting.contains("chests/")) {
            GreedDna.iris_brain_off_brain_enhance(generatedLoot, entity);
            if (idSting.contains("treasure")) {
                this.addLoot(generatedLoot, random, (Item)Items.bat_cell.get(), entity, List.of((Item)Items.cell_blood_attack.get(), (Item)Items.cell_desecrate.get(), (Item)Items.cell_doctor.get(), (Item)Items.cell_fear.get(), (Item)Items.cell_harvest.get(), (Item)Items.cell_immortal.get(), (Item)Items.cell_not_do.get(), (Item)Items.cell_rage.get(), (Item)Items.cell_scientist.get()), (Integer)Config.SERVER.bat.get());
            }
            if (idSting.contains("dungeon") || idSting.contains("mineshaft") || idSting.contains("city") || idSting.contains("treasure")) {
                ManDNA.addLoot(generatedLoot, entity, (Integer)Config.SERVER.lootMan.get());
                this.addLoot(generatedLoot, random, (Item)Items.nightmareeye.get(), entity, List.of((Item)Items.nightmare_orb.get(), (Item)Items.nightmareanchor.get(), (Item)Items.nightmarecharm.get(), (Item)Items.nightmareeye.get(), (Item)Items.nightmaremoai.get(), (Item)Items.nightmarerotten.get(), (Item)Items.nightmarestone.get(), (Item)Items.nightmaretreasure.get(), (Item)Items.nightmarewater.get()), (Integer)Config.SERVER.night.get());
                this.addLoot(generatedLoot, random, (Item)Items.deceased_contract.get(), entity, List.of((Item)BookItems.bone_structure.get(), (Item)BookItems.tumour.get(), (Item)BookItems.organizational_regeneration.get(), (Item)BookItems.mummification.get(), (Item)BookItems.blood_stasis.get(), (Item)BookItems.weak.get(), (Item)BookItems.spore_outbreak.get(), (Item)BookItems.plague_book.get(), (Item)BookItems.exercise_reinforcement.get(), (Item)BookItems.detect.get(), (Item)BookItems.bloodstain.get()), (Integer)Config.SERVER.necora.get());
                this.addLoot(generatedLoot, random, (Item)Items.bloodvirus.get(), entity, List.of((Item)Items.batgene.get(), (Item)Items.batskill.get(), (Item)Items.bloodgene.get(), (Item)Items.botton.get(), (Item)Items.catalyzer.get(), (Item)Items.flygene.get(), (Item)Items.heathgene.get(), (Item)Items.ragegene.get(), (Item)Items.sleepgene.get()), (Integer)Config.SERVER.bat.get());
                this.addLoot(generatedLoot, random, (Item)Items.necora.get(), entity, List.of((Item)Items.ambush.get(), (Item)Items.atpoverdose.get(), (Item)Items.autolytic.get(), (Item)Items.fermentation.get(), (Item)Items.putrefactive.get(), (Item)Items.regenerative.get(), (Item)Items.air.get(), (Item)Items.motor.get(), (Item)Items.watergen.get()), (Integer)Config.SERVER.necora.get());
                if (entity instanceof Player) {
                    player = (Player)entity;
                    boolean wind = Handler.hascurio((LivingEntity)player, (Item)Items.doomeye.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.doomswoud.get());
                    this.addLootHasB(generatedLoot, random, wind, List.of((Item)Items.wind_and_rain.get()), 5);
                }
            }
        }
        if (idSting.contains("chests/") && entity instanceof Player) {
            player = (Player)entity;
            if (idSting.contains("treasure")) {
                if (!player.getTags().contains("treasureRageEye")) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.rage_eye.get()));
                    player.addTag("treasureRageEye");
                }
                boolean ab = !Handler.hascurio((LivingEntity)player, (Item)Items.cell.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.necora.get());
                this.addLootHasB(generatedLoot, random, ab, List.of((Item)Items.cell.get()), 100);
                boolean cellBat = !Handler.hascurio((LivingEntity)player, (Item)Items.bat_cell.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.bloodvirus.get());
                this.addLootHasB(generatedLoot, random, cellBat, List.of((Item)Items.bat_cell.get()), 100);
                if (Handler.hascurio((LivingEntity)player, (Item)Items.necora.get())) {
                    boolean cellGiant = Handler.hascurio((LivingEntity)player, (Item)Items.giant.get());
                    this.addLootHasB(generatedLoot, random, cellGiant, List.of((Item)Items.bone_cell.get(), (Item)Items.parasitic_cell.get(), (Item)Items.mother_cell.get(), (Item)Items.disgusting_cells.get()), (Integer)Config.SERVER.necora.get());
                    boolean cellGiantNig = Handler.hascurio((LivingEntity)player, (Item)Items.giant_nightmare.get());
                    this.addLootHasB(generatedLoot, random, cellGiantNig, List.of((Item)Items.giant_boom_cell.get(), (Item)Items.anaerobic_cell.get(), (Item)Items.subspace_cell.get()), (Integer)Config.SERVER.necora.get());
                    boolean cell = Handler.hascurio((LivingEntity)player, (Item)Items.cell.get());
                    this.addLootHasB(generatedLoot, random, cell, List.of((Item)Items.adrenaline.get(), (Item)Items.cell_mummy.get(), (Item)Items.cell_boom.get(), (Item)Items.cell_calcification.get(), (Item)Items.cell_blood.get()), (Integer)Config.SERVER.necora.get());
                }
            }
        }
        if (idSting.contains("chests/") && idSting.contains("treasure") && entity instanceof Player) {
            player = (Player)entity;
            if (Handler.hascurio((LivingEntity)player, (Item)Items.bloodvirus.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.bat_cell.get())) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.bat_cell.get()));
            }
            if (Handler.hascurio((LivingEntity)player, (Item)Items.necora.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.giant.get()) && Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)10) == 1) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.giant.get()));
            }
        }
        for (ItemStack itemStack : generatedLoot) {
            ServerLevel serverLevel = context.getLevel();
            if (entity instanceof Player) {
                Player player2 = (Player)entity;
                int lv = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100);
                if (Handler.hascurio((LivingEntity)player2, (Item)Items.body_stone.get()) && !itemStack.isEmpty() && itemStack.getItem() instanceof ICurioItem) {
                    int Terror_size = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6);
                    int malice_size = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6);
                    int threat_size = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6);
                    if (Handler.hascurio((LivingEntity)player2, (Item)Items.probability.get())) {
                        ++Terror_size;
                        ++malice_size;
                        ++threat_size;
                    }
                    if (lv <= 50) {
                        Holder.Reference<Enchantment> Terror2 = Enchants.getEnchantHolder(player2, "terror");
                        itemStack.enchant(Terror2, Terror_size);
                        player2.level().playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    if (lv <= 40) {
                        Holder.Reference<Enchantment> malice = Enchants.getEnchantHolder(player2, "malice");
                        itemStack.enchant(malice, malice_size);
                        player2.level().playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    if (lv <= 30) {
                        Holder.Reference<Enchantment> threat = Enchants.getEnchantHolder(player2, "threat");
                        itemStack.enchant(threat, threat_size);
                        player2.level().playSound(null, player2.getX(), player2.getY(), player2.getZ(), SoundEvents.ELDER_GUARDIAN_CURSE, SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                }
            }
            if (!(itemStack.getItem() instanceof Iplague)) continue;
            if (itemStack.get(DataReg.tag) == null) {
                itemStack.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (serverLevel.getDifficulty() == Difficulty.PEACEFUL && itemStack.get(DataReg.tag) != null) {
                ((CompoundTag)itemStack.get(DataReg.tag)).putBoolean(Difficulty.PEACEFUL.getKey(), true);
            }
            if (serverLevel.getDifficulty() == Difficulty.EASY && itemStack.get(DataReg.tag) != null) {
                ((CompoundTag)itemStack.get(DataReg.tag)).putBoolean(Difficulty.EASY.getKey(), true);
            }
            if (serverLevel.getDifficulty() == Difficulty.NORMAL && itemStack.get(DataReg.tag) != null) {
                ((CompoundTag)itemStack.get(DataReg.tag)).putBoolean(Difficulty.NORMAL.getKey(), true);
            }
            if (serverLevel.getDifficulty() != Difficulty.HARD) continue;
            int lv = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)2);
            if (lv == 1) {
                if (itemStack.get(DataReg.tag) == null) continue;
                ((CompoundTag)itemStack.get(DataReg.tag)).putBoolean(Difficulty.HARD.getKey(), true);
                continue;
            }
            if (lv != 2 || itemStack.get(DataReg.tag) == null) continue;
            ((CompoundTag)itemStack.get(DataReg.tag)).putBoolean("god_loot", true);
        }
        for (ItemStack itemStack : generatedLoot) {
            BookEvt.addLvl(itemStack, Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6000), Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)6000));
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            TheBloodBook.tryDoLoot(generatedLoot, (LivingEntity)player);
        }
        if (idSting.contains("chests/") && idSting.contains("ancient")) {
            AdvancementEvt.addLoot(generatedLoot, entity, 5);
            AdvancementEvt.nightmare_base_reversal_mysteriousLOOT(generatedLoot, entity);
        }
        if (idSting.contains("chests/") && (idSting.contains("dungeon") || idSting.contains("mansion"))) {
            this.give(generatedLoot, entity, 10, "defend_against_runestone", (Item)com.ytgld.seeking_immortals.init.Items.nightmare_base.get(), (Item)com.ytgld.seeking_immortals.init.Items.defend_against_runestone.get());
            this.give(generatedLoot, entity, 10, "revive_runestone", (Item)com.ytgld.seeking_immortals.init.Items.nightmare_base.get(), (Item)com.ytgld.seeking_immortals.init.Items.revive_runestone.get());
            this.give(generatedLoot, entity, 10, "strengthen_runestone", (Item)com.ytgld.seeking_immortals.init.Items.nightmare_base.get(), (Item)com.ytgld.seeking_immortals.init.Items.strengthen_runestone.get());
        }
        if (idSting.contains("chests/")) {
            if (idSting.contains("dungeon")) {
                AdvancementEvt.nightmare_base_start_pod(generatedLoot, entity);
            }
            if (idSting.contains("mansion")) {
                AdvancementEvt.tricky_puppets(generatedLoot, entity);
            }
        }
        return generatedLoot;
    }

    public static void heal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        float h;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.get(DataReg.tag) == null || (h = ((CompoundTag)stack.get(DataReg.tag)).getFloat("the_doctor")) == 0.0f) continue;
                        event.setAmount(event.getAmount() + h);
                    }
                }
            });
        }
    }

    public static void heal(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            CuriosApi.getCuriosInventory((LivingEntity)player2).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        float h;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.get(DataReg.tag) == null || (h = ((CompoundTag)stack.get(DataReg.tag)).getFloat("the_chromosome")) == 0.0f) continue;
                        event.setNewSpeed(event.getNewSpeed() + h);
                    }
                }
            });
        }
    }

    public static void cit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            CuriosApi.getCuriosInventory((LivingEntity)player2).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        float h;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.get(DataReg.tag) == null || (h = ((CompoundTag)stack.get(DataReg.tag)).getFloat("the_cell")) == 0.0f) continue;
                        event.setDamageMultiplier(event.getDamageMultiplier() + h);
                    }
                }
            });
        }
    }

    public static void attack(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        float h;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.get(DataReg.tag) == null || (h = ((CompoundTag)stack.get(DataReg.tag)).getFloat("the_die")) == 0.0f) continue;
                        event.setAmount(event.getAmount() + h);
                    }
                }
            });
        }
    }
}

