/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.blood;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.event.TextEvt;
import com.moonstone.moonstonemod.init.items.moonstoneitem.i.Blood;
import com.moonstone.moonstonemod.init.other.AttReg;
import com.moonstone.moonstonemod.init.other.DataReg;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Killer
extends Item
implements ICurioItem,
Blood,
TextEvt.Twelve {
    public static final String uDead = "undead";

    public Killer() {
        super(new Item.Properties().stacksTo(1).durability(1000000000).rarity(Rarity.UNCOMMON));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (stack.get(DataReg.tag) == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if ((livingEntity = slotContext.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            float lv = player.getHealth() / player.getMaxHealth();
            int now = (int)(100.0f - (lv *= 100.0f));
            if (stack.get(DataReg.tag) == null) {
                stack.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (stack.get(DataReg.tag) != null) {
                ((CompoundTag)stack.get(DataReg.tag)).putInt(uDead, now);
            }
            player.getAttributes().addTransientAttributeModifiers(this.ad(stack));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getAttributes().removeAttributeModifiers(this.ad(stack));
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> ad(ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (stack.get(DataReg.tag) != null) {
            int lvl = ((CompoundTag)stack.get(DataReg.tag)).getInt(uDead);
            float heal = 0.0125f * (float)lvl;
            float speed = 0.008f * (float)lvl;
            float damage = 0.0075f * (float)lvl;
            float attSpeed = 0.005f * (float)lvl;
            float armor = 0.0034999999f * (float)lvl;
            modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)heal, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)attSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)armor, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.1").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.2").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.3").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.4").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.5").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.6").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.literal((String)""));
        if (stack.get(DataReg.tag) != null) {
            int lvl = ((CompoundTag)stack.get(DataReg.tag)).getInt(uDead);
            float heal = 0.0125f * (float)lvl;
            float speed = 0.008f * (float)lvl;
            float damage = 0.0075f * (float)lvl;
            float attSpeed = 0.005f * (float)lvl;
            float armor = 0.0034999999f * (float)lvl;
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.7").withStyle(ChatFormatting.DARK_RED));
            DecimalFormat df = new DecimalFormat("#.###");
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.8").append(df.format(heal * 100.0f) + "%").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.9").append(df.format(speed * 100.0f) + "%").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.10").append(df.format(damage * 100.0f) + "%").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.11").append(df.format(attSpeed * 100.0f) + "%").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.translatable((String)"item.killer.tool.string.12").append(df.format(armor * 100.0f) + "%").withStyle(ChatFormatting.DARK_RED));
        }
        tooltip.add((Component)Component.literal((String)""));
    }
}

