/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.blood;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.entity.AttackBlood;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.items.moonstoneitem.i.Blood;
import com.moonstone.moonstonemod.init.other.DataReg;
import com.moonstone.moonstonemod.init.other.EntityTs;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class max_blood_cube
extends Item
implements ICurioItem,
Blood {
    public static final String slowing = "Slowing";
    public static final int slowingMax = 100;

    public max_blood_cube() {
        super(new Item.Properties().stacksTo(1).durability(1000000000).rarity(Rarity.UNCOMMON));
    }

    public static void RightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Entity entity = max_blood_cube.getPlayerLookTarget(player.level(), (LivingEntity)player);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (player.isShiftKeyDown()) {
                player.getCooldowns().addCooldown((Item)Items.max_blood_cube.get(), 4);
            }
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Player player;
        LivingEntity livingEntity;
        CompoundTag tag = (CompoundTag)stack.get(DataReg.tag);
        if (tag == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if ((livingEntity = slotContext.entity()) instanceof Player && !(player = (Player)livingEntity).getCooldowns().isOnCooldown((Item)this) && stack.get(DataReg.tag) != null && ((CompoundTag)stack.get(DataReg.tag)).getInt(slowing) > 0) {
            ((CompoundTag)stack.get(DataReg.tag)).putInt(slowing, ((CompoundTag)stack.get(DataReg.tag)).getInt(slowing) - 1);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Entity entity;
        Player player;
        stack.setDamageValue(stack.getDamageValue() + 1);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getCooldowns().isOnCooldown((Item)this) && (entity = max_blood_cube.getPlayerLookTarget(player.level(), (LivingEntity)player)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 2, 1, false, false));
            if (stack.get(DataReg.tag) != null) {
                if (((CompoundTag)stack.get(DataReg.tag)).getInt(slowing) < 100) {
                    ((CompoundTag)stack.get(DataReg.tag)).putInt(slowing, ((CompoundTag)stack.get(DataReg.tag)).getInt(slowing) + 2);
                }
                if (((CompoundTag)stack.get(DataReg.tag)).getInt(slowing) >= 80 && player.tickCount % 3 == 0) {
                    AttackBlood attack_blood = new AttackBlood((EntityType<? extends AttackBlood>)((EntityType)EntityTs.attack_blood.get()), player.level());
                    attack_blood.setPos(new Vec3(living.getX() + (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-2.0f, (float)2.0f), living.getY() + (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-2.2f, (float)2.2f), living.getZ() + (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-2.1f, (float)2.1f)));
                    living.level().addFreshEntity((Entity)attack_blood);
                }
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"item.max_blood_cube.tool.string").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)"item.max_blood_cube.tool.string.1").withStyle(ChatFormatting.RED));
        } else {
            pTooltipComponents.add((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.DARK_RED));
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (stack.get(DataReg.tag) != null) {
            modifierMultimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)((float)(-((CompoundTag)stack.get(DataReg.tag)).getInt(slowing)) / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifierMultimap;
    }

    public static Entity getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }
}

