/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.decorated;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.BloodItemEntity;
import com.moonstone.moonstonemod.entity.extend.MoonTamableAnimal;
import com.moonstone.moonstonemod.entity.zombie.CellGiant;
import com.moonstone.moonstonemod.entity.zombie.CellZombie;
import com.moonstone.moonstonemod.init.items.BookItems;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.items.moonstoneitem.extend.TheNecoraIC;
import com.moonstone.moonstonemod.init.other.AttReg;
import com.moonstone.moonstonemod.init.other.DataReg;
import com.moonstone.moonstonemod.init.other.EntityTs;
import com.ytgld.seeking_immortals.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class DeceasedContract
extends TheNecoraIC {
    private final String time = "CurseTime";
    private final int maxTime = 3600;

    public static void attack(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)livingEntity), (Item)Items.deceased_contract.get()) && event.getAmount() < 2.1474836E9f) {
            event.setAmount(event.getAmount() * 1.25f);
        }
    }

    public static void Did(LivingDeathEvent event) {
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)entity), (Item)Items.deceased_contract.get())) {
            if (Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) <= 30) {
                CellZombie z = new CellZombie((EntityType<? extends CellZombie>)((EntityType)EntityTs.cell_zombie.get()), player.level());
                z.teleportTo(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ());
                z.setOwnerUUID(player.getUUID());
                z.getAttributes().addTransientAttributeModifiers(DeceasedContract.zombieAtt(player));
                z.heal(1000.0f);
                for (MobEffectInstance effect : player.getActiveEffects()) {
                    if (effect == null || !((MobEffect)effect.getEffect().value()).isBeneficial()) continue;
                    z.addEffect(effect);
                }
                DeceasedContract.addTag(z, player);
                z.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 6, false, false));
                player.level().addFreshEntity((Entity)z);
            }
            if (Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) <= 15) {
                CellGiant g = new CellGiant((EntityType<? extends CellGiant>)((EntityType)EntityTs.cell_giant.get()), player.level());
                g.teleportTo(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ());
                g.setOwnerUUID(player.getUUID());
                g.getAttributes().addTransientAttributeModifiers(DeceasedContract.zombieAtt(player));
                g.heal(1000.0f);
                g.setPose(Pose.EMERGING);
                for (MobEffectInstance effect : player.getActiveEffects()) {
                    if (effect == null || !((MobEffect)effect.getEffect().value()).isBeneficial()) continue;
                    g.addEffect(effect);
                }
                player.level().playSound(null, player.blockPosition(), SoundEvents.WARDEN_EMERGE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                DeceasedContract.addTag(g, player);
                g.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60, 6, false, false));
                player.level().addFreshEntity((Entity)g);
            }
            if (Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) <= 15) {
                BloodItemEntity blood2 = new BloodItemEntity((EntityType<? extends BloodItemEntity>)((EntityType)EntityTs.blood.get()), player.level());
                blood2.setDeltaMovement(Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.1, (double)0.11), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.095, (double)0.1), Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.099, (double)0.1));
                blood2.setOwner((Entity)player);
                blood2.setPos(event.getEntity().getX(), event.getEntity().getY() + 1.5, event.getEntity().getZ());
                player.level().addFreshEntity((Entity)blood2);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int time;
        CompoundTag compoundTag;
        slotContext.entity().getAttributes().addTransientAttributeModifiers(this.getAttributeModifiers());
        if (stack.get(DataReg.tag) == null) {
            compoundTag = new CompoundTag();
            compoundTag.putInt(this.time, 3600);
            stack.set(DataReg.tag, (Object)compoundTag);
        }
        if (!slotContext.entity().level().isClientSide && slotContext.entity().tickCount % 20 == 0 && (compoundTag = (CompoundTag)stack.get(DataReg.tag)) != null && (time = compoundTag.getInt(this.time)) > 0) {
            compoundTag.putInt(this.time, compoundTag.getInt(this.time) - 1);
        }
        String tag = "curioTickDeceasedContract";
        if (stack.get(DataReg.tag) != null && !((CompoundTag)stack.get(DataReg.tag)).getBoolean(tag)) {
            Random random = new Random();
            ArrayList<Item> items = new ArrayList<Item>(List.of((Item)Items.muscle_conversion.get(), (Item)Items.phosphate_bond.get(), (Item)Items.chemical_compound.get(), (Item)Items.skin_glucose_fermentation.get(), (Item)Items.white_blood_cells_are_abruptly_reduced.get()));
            if (!items.isEmpty()) {
                int index = random.nextInt(items.size());
                Item selectedItem = items.remove(index);
                this.addLoot((Entity)slotContext.entity(), selectedItem);
            }
            ((CompoundTag)stack.get(DataReg.tag)).putBoolean(tag, true);
        }
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
            return true;
        }
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null && compoundTag.getInt(this.time) <= 0) {
            return true;
        }
        return (Boolean)Config.SERVER.canUnequipMoonstoneItem.get();
    }

    private void addLoot(Entity entity, Item itemList) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.addItem(itemList.getDefaultInstance());
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        slotContext.entity().getAttributes().removeAttributeModifiers(this.getAttributeModifiers());
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers() {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put(AttReg.alL_attack, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifierMultimap.put(AttReg.cit, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifierMultimap.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), -0.3, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifierMultimap;
    }

    private static Multimap<Holder<Attribute>, AttributeModifier> zombieAtt(Player owner) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (owner.getAttribute(Attributes.ATTACK_DAMAGE) != null) {
            modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + ((Item)Items.deceased_contract.get()).getDescriptionId())), owner.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (owner.getAttribute(Attributes.ARMOR) != null) {
            modifierMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + ((Item)Items.deceased_contract.get()).getDescriptionId())), owner.getAttribute(Attributes.ARMOR).getValue() / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (owner.getAttribute(Attributes.MAX_HEALTH) != null) {
            modifierMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + ((Item)Items.deceased_contract.get()).getDescriptionId())), owner.getAttribute(Attributes.MAX_HEALTH).getValue() / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (owner.getAttribute(Attributes.ATTACK_DAMAGE) != null) {
            modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + ((Item)Items.deceased_contract.get()).getDescriptionId())), owner.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        if (owner.getAttribute(Attributes.MOVEMENT_SPEED) != null) {
            modifierMultimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + ((Item)Items.deceased_contract.get()).getDescriptionId())), owner.getAttribute(Attributes.MOVEMENT_SPEED).getValue() / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        modifierMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage_a" + ((Item)Items.deceased_contract.get()).getDescriptionId())), (double)-0.8f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifierMultimap;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        CuriosApi.addSlotModifier((Multimap)multimap, (String)"necora", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        return multimap;
    }

    private static void addTag(MoonTamableAnimal tamableAnimal, Player owner) {
        if (Handler.hascurio((LivingEntity)owner, (Item)BookItems.blood_stasis.get())) {
            tamableAnimal.addTag("blood_stasisTAG");
        }
        if (Handler.hascurio((LivingEntity)owner, (Item)BookItems.mummification.get())) {
            tamableAnimal.addTag("mummificationTAG");
        }
        if (Handler.hascurio((LivingEntity)owner, (Item)BookItems.tumour.get())) {
            tamableAnimal.addTag("tumourTAG");
        }
        if (Handler.hascurio((LivingEntity)owner, (Item)BookItems.organizational_regeneration.get())) {
            tamableAnimal.addTag("organizational_regenerationTAG");
        }
        if (Handler.hascurio((LivingEntity)owner, (Item)BookItems.bone_structure.get())) {
            tamableAnimal.addTag("bone_structureTAG");
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.0").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.1").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.2").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.3").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.4").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.5").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.6").withStyle(ChatFormatting.DARK_RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.RED));
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null && compoundTag.getInt(this.time) > 0) {
                tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.7").append(String.valueOf(compoundTag.getInt(this.time))).append((Component)Component.translatable((String)"item.deceased_contract.tool.string.8")).withStyle(ChatFormatting.DARK_RED));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"item.deceased_contract.tool.string.9").withStyle(ChatFormatting.GOLD));
            }
        }
    }
}

