/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.maxitem;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TheHeart
extends BundleItem
implements ICurioItem {
    public TheHeart() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY).rarity(Rarity.UNCOMMON));
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean overrideOtherStackedOnMe(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pStack.getCount() != 1) {
            return false;
        }
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer)) {
            BundleContents bundlecontents = (BundleContents)pStack.get(DataComponents.BUNDLE_CONTENTS);
            if (bundlecontents == null) {
                return false;
            }
            BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(bundlecontents);
            if (pOther.isEmpty()) {
                ItemStack itemstack = bundlecontents$mutable.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)pPlayer);
                    pAccess.set(itemstack);
                }
            } else {
                int i = bundlecontents$mutable.tryInsert(pOther);
                if (i > 0) {
                    this.playInsertSound((Entity)pPlayer);
                }
            }
            pStack.set(DataComponents.BUNDLE_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public int getBarWidth(ItemStack pStack) {
        return 4;
    }

    public InteractionResultHolder<ItemStack> use(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        ItemStack itemstack = p_150761_.getItemInHand(p_150762_);
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)p_150760_.isClientSide());
    }

    public int getBarColor(ItemStack p_150901_) {
        float stackMaxDamage = this.getBarWidth(p_150901_);
        float f = Math.max(0.0f, stackMaxDamage - 64.0f / stackMaxDamage);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.the_heart.tool.string").withStyle(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.translatable((String)"item.the_heart.tool.string.1").withStyle(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.translatable((String)"item.the_heart.tool.string.2").withStyle(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.translatable((String)""));
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.IRON_GOLEM_REPAIR, 0.8f, 0.8f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.playSound(SoundEvents.IRON_GOLEM_REPAIR, 0.8f, 0.8f + p_186352_.level().getRandom().nextFloat() * 0.4f);
    }
}

