/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.maxitem.uncommon;

import com.moonstone.moonstonemod.init.other.DataReg;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class Evilmug
extends Item {
    public static String blood = "blood";

    public Evilmug() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).food(new FoodProperties.Builder().alwaysEdible().nutrition(1).saturationModifier(0.2f).build()));
    }

    public UseAnim getUseAnimation(ItemStack p_41452_) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        pPlayer.startUsingItem(pUsedHand);
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public ItemStack finishUsingItem(ItemStack s, Level level, LivingEntity living) {
        CompoundTag tag = (CompoundTag)s.get((DataComponentType)DataReg.tag.get());
        if (tag != null) {
            if (tag.getInt(blood) > 0) {
                living.heal(10.0f);
                if (tag.getInt(blood) >= 10) {
                    tag.putInt(blood, tag.getInt(blood) - 10);
                } else {
                    tag.putInt(blood, tag.getInt(blood) - tag.getInt(blood));
                }
            } else {
                living.hurt(living.damageSources().magic(), 10.0f);
                tag.putInt(blood, tag.getInt(blood) + 10);
            }
        } else {
            s.set(DataReg.tag, (Object)new CompoundTag());
        }
        return s;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        CompoundTag tag = (CompoundTag)pStack.get((DataComponentType)DataReg.tag.get());
        if (tag != null) {
            pTooltipComponents.add((Component)Component.translatable((String)String.valueOf(tag)).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
            pTooltipComponents.add((Component)Component.translatable((String)""));
            if (tag != null) {
                if (tag.getInt(blood) <= 0) {
                    pTooltipComponents.add((Component)Component.translatable((String)"item.evilmug.tool.string").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
                    pTooltipComponents.add((Component)Component.translatable((String)"item.evilmug.tool.string.1").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
                    pTooltipComponents.add((Component)Component.translatable((String)""));
                    pTooltipComponents.add((Component)Component.translatable((String)"item.evilmug.tool.string.2").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
                } else {
                    pTooltipComponents.add((Component)Component.translatable((String)"item.evilmug.tool.string.3").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
                }
                pTooltipComponents.add((Component)Component.translatable((String)("Blood : " + tag.getInt(blood))).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
            }
        }
    }
}

