/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.plague;

import com.moonstone.moonstonemod.contents.BundleContentsDNA;
import com.moonstone.moonstonemod.init.items.DNAItems;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.items.moonstoneitem.i.Iplague;
import com.moonstone.moonstonemod.init.other.DataReg;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class CraftingBox
extends Item
implements Iplague {
    public CraftingBox() {
        super(new Item.Properties().stacksTo(1).component(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY).rarity(Rarity.UNCOMMON));
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            BundleContentsDNA bundlecontents = (BundleContentsDNA)stack.get(DataReg.SUPER_BAG);
            if (bundlecontents == null) {
                return false;
            }
            BundleContentsDNA.Mutable bundlecontents$mutable = new BundleContentsDNA.Mutable(bundlecontents);
            if (other.isEmpty()) {
                ItemStack itemstack = bundlecontents$mutable.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)player);
                    access.set(itemstack);
                }
            } else {
                int i = bundlecontents$mutable.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            stack.set(DataReg.SUPER_BAG, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            if (CraftingBox.dropContents(itemstack, player)) {
                this.playDropContentsSound((Entity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        } else {
            player.startUsingItem(usedHand);
        }
        return super.use(level, player, usedHand);
    }

    private boolean checkCondition(BundleContentsDNA bundlecontents, DeferredHolder<Item, ?> itemType, int count) {
        for (ItemStack item : bundlecontents.items()) {
            if (!item.is(itemType) || item.getCount() != count) continue;
            return true;
        }
        return false;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BundleContentsDNA bundlecontents = (BundleContentsDNA)stack.get(DataReg.SUPER_BAG);
            if (bundlecontents != null && this.checkCondition(bundlecontents, DNAItems.atp_height, 48) && this.checkCondition(bundlecontents, DNAItems.cell_darwin, 32) && this.checkCondition(bundlecontents, DNAItems.cell_off_on, 32) && this.checkCondition(bundlecontents, DNAItems.cell_disorder, 20) && this.checkCondition(bundlecontents, DNAItems.cell_synthesis, 12) && this.checkCondition(bundlecontents, DNAItems.cell_dna_suppression, 24) && this.checkCondition(bundlecontents, DNAItems.cell_necrosis, 8) && this.checkCondition(bundlecontents, Items.ectoplasmprism, 1)) {
                player.addItem(new ItemStack(Items.necora));
                stack.set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            }
            if (bundlecontents != null && this.checkCondition(bundlecontents, DNAItems.atp_height, 20) && this.checkCondition(bundlecontents, DNAItems.cell_god, 16) && this.checkCondition(bundlecontents, DNAItems.speed_metabolism, 40) && this.checkCondition(bundlecontents, DNAItems.cell_disorder, 64) && this.checkCondition(bundlecontents, DNAItems.cell_necrosis, 24) && this.checkCondition(bundlecontents, Items.ectoplasmprism, 1) && this.checkCondition(bundlecontents, Items.ectoplasmball, 8)) {
                player.addItem(new ItemStack(Items.cell));
                stack.set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            }
            if (bundlecontents != null && this.checkCondition(bundlecontents, DNAItems.atp_height, 30) && this.checkCondition(bundlecontents, DNAItems.cell_god, 24) && this.checkCondition(bundlecontents, DNAItems.speed_metabolism, 60) && this.checkCondition(bundlecontents, DNAItems.cell_disorder, 64) && this.checkCondition(bundlecontents, DNAItems.cell_necrosis, 12) && this.checkCondition(bundlecontents, Items.ectoplasmprism, 1) && this.checkCondition(bundlecontents, Items.cell, 1)) {
                player.addItem(new ItemStack(Items.giant));
                stack.set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            }
            if (bundlecontents != null && this.checkCondition(bundlecontents, DNAItems.atp_height, 64) && this.checkCondition(bundlecontents, DNAItems.speed_metabolism, 16) && this.checkCondition(bundlecontents, DNAItems.cell_dna_suppression, 64) && this.checkCondition(bundlecontents, DNAItems.cell_synthesis, 64) && this.checkCondition(bundlecontents, DNAItems.cell_darwin, 64) && this.checkCondition(bundlecontents, DNAItems.cell_off_on, 64) && this.checkCondition(bundlecontents, Items.ectoplasmprism, 1) && this.checkCondition(bundlecontents, Items.giant, 1)) {
                player.addItem(new ItemStack(Items.giant_nightmare));
                stack.set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            }
        }
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        BundleContentsDNA bundlecontents = (BundleContentsDNA)stack.getOrDefault(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
        return bundlecontents.weight().compareTo(Fraction.ZERO) > 0;
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        BundleContentsDNA bundlecontents = (BundleContentsDNA)stack.get(DataReg.SUPER_BAG);
        if (bundlecontents != null && !bundlecontents.isEmpty()) {
            stack.set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            if (player instanceof ServerPlayer) {
                bundlecontents.itemsCopy().forEach(p_330078_ -> player.drop(p_330078_, true));
            }
            return true;
        }
        return false;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        BundleContentsDNA bundlecontents = (BundleContentsDNA)itemEntity.getItem().get(DataReg.SUPER_BAG);
        if (bundlecontents != null) {
            itemEntity.getItem().set(DataReg.SUPER_BAG, (Object)BundleContentsDNA.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, bundlecontents.itemsCopy());
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (Screen.hasShiftDown()) {
            BundleContentsDNA bundlecontents = (BundleContentsDNA)pStack.get(DataReg.SUPER_BAG);
            if (bundlecontents != null) {
                bundlecontents.items().forEach(itemStack -> pTooltipComponents.add((Component)Component.translatable((String)itemStack.getDescriptionId()).append("\uff1a" + itemStack.getCount()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-1154205)))));
            }
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-5103070))));
            pTooltipComponents.add((Component)Component.literal((String)""));
        }
    }
}

