/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.plague.mob_item;

import com.moonstone.moonstonemod.event.AllEvent;
import com.moonstone.moonstonemod.init.items.moonstoneitem.extend.MedIC;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Fungus
extends MedIC
implements ICurioItem {
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            BlockState state;
            Player player = (Player)livingEntity;
            Vec3 playerPos = player.position().add(0.0, 0.75, 0.0);
            int range = 10;
            List entities = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity entity : entities) {
                if (player.level().isClientSide || player.tickCount % 80 != 0) continue;
                this.fungus_pets(entity, player);
            }
            if (player.level().isDay() && player.level().canSeeSkyFromBelowWater(new BlockPos(player.getBlockX(), player.getBlockY() - 1, player.getBlockZ()))) {
                player.setRemainingFireTicks(2);
            }
            if (player.hasEffect(MobEffects.POISON) || player.hasEffect(MobEffects.WITHER) || player.hasEffect(MobEffects.WEAKNESS) || player.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                player.removeEffect(MobEffects.POISON);
                player.removeEffect(MobEffects.WEAKNESS);
                player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                player.removeEffect(MobEffects.WITHER);
            }
            if ((state = player.level().getBlockState(new BlockPos(player.getBlockX(), player.getBlockY() - 1, player.getBlockZ()))).is(Blocks.GRASS_BLOCK)) {
                player.level().setBlock(new BlockPos(player.getBlockX(), player.getBlockY() - 1, player.getBlockZ()), Blocks.MYCELIUM.defaultBlockState(), 3);
            }
            if (state.is(Blocks.MYCELIUM) && !player.level().isClientSide && player.tickCount % 200 == 0) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 220, 1));
            }
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.1").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.2").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)""));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.3").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.4").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)""));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.5").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)""));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.6").withStyle(ChatFormatting.RED));
            pTooltipComponents.add((Component)Component.translatable((String)""));
            pTooltipComponents.add((Component)Component.translatable((String)"item.fungus.tool.string.7").withStyle(ChatFormatting.RED));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"Shift").withStyle(ChatFormatting.DARK_RED));
        }
        pTooltipComponents.add((Component)Component.translatable((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)("Heal: " + AllEvent.aFloat * 100.0f + "%")).withStyle(ChatFormatting.DARK_RED));
    }

    public void fungus_pets(LivingEntity living, Player player) {
        OwnableEntity ownableEntity;
        if (!living.is((Entity)player) && living.isAlliedTo((Entity)player)) {
            living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 1));
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1));
        }
        if (living instanceof OwnableEntity && (ownableEntity = (OwnableEntity)living).getOwner() != null && ownableEntity.getOwner().is((Entity)player)) {
            living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 1));
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 1));
            living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 100, 1));
        }
    }
}

