/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.mixin.other;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.Items;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Shadow
    public abstract FluidState getFluidState();

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")}, cancellable=true)
    private void addFluidCollision(BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContext context;
        Entity entity;
        FluidState fluidState = this.getFluidState();
        if (collisionContext instanceof EntityCollisionContext && (entity = (context = (EntityCollisionContext)collisionContext).getEntity()) instanceof LivingEntity) {
            VoxelShape fluidShape;
            LivingEntity entity2 = (LivingEntity)entity;
            if (Handler.hascurio(entity2, (Item)Items.ambush.get())) {
                double stepHeight = 1.0;
                fluidShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidState.getHeight(blockGetter, blockPos), (double)1.0);
                if (collisionContext.isAbove(fluidShape.move(0.0, -stepHeight, 0.0), blockPos, false)) {
                    cir.setReturnValue((Object)Shapes.or((VoxelShape)fluidShape, (VoxelShape)((VoxelShape)cir.getReturnValue())));
                }
            }
            if (Handler.hascurio(entity2, (Item)Items.evilcandle.get()) && fluidState.is((Fluid)Fluids.LAVA)) {
                double stepHeight = 1.0;
                fluidShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidState.getHeight(blockGetter, blockPos), (double)1.0);
                if (collisionContext.isAbove(fluidShape.move(0.0, -stepHeight, 0.0), blockPos, false)) {
                    cir.setReturnValue((Object)Shapes.or((VoxelShape)fluidShape, (VoxelShape)((VoxelShape)cir.getReturnValue())));
                }
            }
        }
    }
}

