/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.mixin.other;

import com.moonstone.moonstonemod.init.other.Enchants;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public abstract class EnchantmentMixin {
    @Inject(at={@At(value="HEAD")}, method={"getFullname"}, cancellable=true)
    private static void getFullname(Holder<Enchantment> enchantment, int level, CallbackInfoReturnable<Component> cir) {
        if (Enchants.isMoonEnchant(enchantment, "terror")) {
            cir.setReturnValue((Object)Component.translatable((String)"enchantment.moonstone.terror").append(" " + level).withStyle(ChatFormatting.RED));
        }
        if (Enchants.isMoonEnchant(enchantment, "malice")) {
            cir.setReturnValue((Object)Component.translatable((String)"enchantment.moonstone.malice").append(" " + level).withStyle(ChatFormatting.RED));
        }
        if (Enchants.isMoonEnchant(enchantment, "threat")) {
            cir.setReturnValue((Object)Component.translatable((String)"enchantment.moonstone.threat").append(" " + level).withStyle(ChatFormatting.RED));
        }
    }
}

