/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.base;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.AttReg;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.NightmareYTGLD;
import com.ytgld.seeking_immortals.item.nightmare.extend.SuperNightmare;
import com.ytgld.seeking_immortals.item.nightmare.tip.Terror;
import com.ytgld.seeking_immortals.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class BloodRing
extends NightmareYTGLD
implements SuperNightmare {
    public static final String blood = "BloodName";
    public static final String bloodtime = "bloodTimeName";
    public static final String give_End = "give_End_blood_ring";
    public static final String giveName_damage = "giveName_damage_blood_ring";

    public static void giveBlood(Player player, ItemStack stack) {
        Item item;
        if (Handler.hascurio((LivingEntity)player, (Item)Items.blood_ring.get()) && !player.getCooldowns().isOnCooldown((Item)Items.blood_ring.get()) && stack.is((Item)Items.blood_ring.get()) && (item = stack.getItem()) instanceof NightmareYTGLD) {
            NightmareYTGLD nightmare = (NightmareYTGLD)item;
            float s = player.getHealth() / 2.0f;
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null) {
                float sa = s * (1.0f + (float)nightmare.nowLevel(stack) / 100.0f);
                if (player.getHealth() >= player.getMaxHealth() && compoundTag.getInt("SITheTerrorName") < nightmare.maxLevel(stack)) {
                    compoundTag.putInt("SITheTerrorName", compoundTag.getInt("SITheTerrorName") + 5);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                player.hurt(player.damageSources().genericKill(), s);
                player.getFoodData().eat(-10, -10.0f);
                compoundTag.putInt(bloodtime, (int)(300.0f + sa));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.RAVAGER_ROAR, SoundSource.AMBIENT, 0.25f, 0.25f);
                float sb = player.getHealth() / 2.0f;
                float sd = sb * (1.0f + (float)nightmare.nowLevel(stack) / 100.0f);
                compoundTag.putFloat(blood, sd);
                player.getCooldowns().addCooldown((Item)Items.blood_ring.get(), (int)(100.0f + sa));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() instanceof Player && !slotContext.entity().level().isClientSide) {
            slotContext.entity().getAttributes().addTransientAttributeModifiers(this.ad(stack, this));
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null) {
                if (compoundTag.getFloat(blood) > 100.0f) {
                    compoundTag.putFloat(blood, 100.0f);
                }
                if (compoundTag.getInt(bloodtime) <= 0) {
                    compoundTag.putFloat(blood, 0.0f);
                } else {
                    compoundTag.putInt(bloodtime, compoundTag.getInt(bloodtime) - 1);
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!slotContext.entity().level().isClientSide) {
            slotContext.entity().getAttributes().removeAttributeModifiers(this.ad(stack, this));
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> ad(ItemStack stack, Terror terror) {
        HashMultimap modifiers = HashMultimap.create();
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            float s = 0.0f;
            if (compoundTag.getInt(bloodtime) > 0) {
                s = compoundTag.getFloat(blood) / 100.0f / 2.0f;
            }
            modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)(-s), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifiers;
    }

    @Override
    public int nowLevel(ItemStack stack) {
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            return compoundTag.getInt("SITheTerrorName");
        }
        return 0;
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 20, 100, 255);
    }

    @Override
    public int maxLevel(ItemStack stack) {
        return 150;
    }

    @Override
    public ResourceLocation image(@Nullable LivingEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/gui/tooltip/cube.png");
    }

    @Override
    public boolean isRot(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.blood_ring.tool.string.1").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.blood_ring.tool.string.2").append((Component)Component.literal((String)String.format("%.2f", 0.5 * (double)(1.0f + (float)this.nowLevel(stack) / 100.0f)))).append("% ").append((Component)Component.translatable((String)"item.blood_ring.tool.string.3")).withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.blood_ring.tool.string.4").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.blood_ring.tool.string.5").withStyle(ChatFormatting.GOLD));
    }
}

