/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.base;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.AttReg;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.NightmareYTGLD;
import com.ytgld.seeking_immortals.item.nightmare.tip.Terror;
import com.ytgld.seeking_immortals.renderer.light.Light;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class CrazyDrug
extends NightmareYTGLD {
    public static final String drugClear = "drugClear";
    public static final String effectCooldown = "effectCooldown";
    public static final String drugSize = "drugSize";
    public static final String drugTime = "drugTime";
    public static final String drugStronger = "drugStronger";
    public static final String drugWeakness = "drugWeakness";
    public static final String giveDrug = "giveDrug";

    public static void crazy_drugAddEffect(Player player, ItemStack stack) {
        Item item;
        if (Handler.hascurio((LivingEntity)player, (Item)Items.crazy_drug.get()) && stack.is((Item)Items.crazy_drug.get()) && (item = stack.getItem()) instanceof CrazyDrug) {
            CrazyDrug drug = (CrazyDrug)item;
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null && compoundTag.getInt(drugSize) > 0 && compoundTag.getInt(effectCooldown) <= 0) {
                if (compoundTag.getInt("SITheTerrorName") < drug.maxLevel(stack)) {
                    compoundTag.putInt("SITheTerrorName", compoundTag.getInt("SITheTerrorName") + 1);
                }
                compoundTag.putInt(drugWeakness, compoundTag.getInt(drugWeakness) + 5);
                float stronger = 50.0f * (1.0f + (float)drug.nowLevel(stack) / 100.0f);
                float weakness = compoundTag.getInt(drugWeakness);
                compoundTag.putFloat(drugStronger, (stronger -= (weakness /= 1.0f + (float)drug.nowLevel(stack) / 100.0f)) / 100.0f);
                compoundTag.putInt(drugTime, (int)(400.0f * (1.0f + (float)drug.nowLevel(stack) / 100.0f)));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITCH_DRINK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.heal(player.getMaxHealth() * 0.1f);
                compoundTag.putInt(drugSize, compoundTag.getInt(drugSize) - 1);
                compoundTag.putInt(effectCooldown, 2);
            }
        }
    }

    public static void give(ItemStack stack, Player player) {
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null && !compoundTag.getBoolean(giveDrug)) {
            player.addItem(new ItemStack((ItemLike)Items.crazy_drug.get()));
            compoundTag.putBoolean(giveDrug, true);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
                player.getAttributes().addTransientAttributeModifiers(this.ad(stack, this));
                int value = (int)player.getAttributeValue(AttReg.effectNumber);
                if (compoundTag != null) {
                    if (compoundTag.getInt(effectCooldown) > 0) {
                        compoundTag.putInt(effectCooldown, compoundTag.getInt(effectCooldown) - 1);
                    }
                    if (!compoundTag.getBoolean(drugClear)) {
                        compoundTag.putInt(drugWeakness, 0);
                        compoundTag.putInt(drugSize, value);
                        compoundTag.putBoolean(drugClear, true);
                    }
                    if (compoundTag.getInt(drugTime) > 0) {
                        compoundTag.putInt(drugTime, compoundTag.getInt(drugTime) - 1);
                    }
                    if (!player.getCooldowns().isOnCooldown((Item)Items.crazy_drug.get())) {
                        if (compoundTag.getInt(drugWeakness) > 0) {
                            compoundTag.putInt(drugWeakness, compoundTag.getInt(drugWeakness) - 7);
                        }
                        if (compoundTag.getInt(drugSize) < value) {
                            compoundTag.putInt(drugSize, compoundTag.getInt(drugSize) + 2);
                        }
                        player.getCooldowns().addCooldown((Item)Items.crazy_drug.get(), (int)(350.0f / (1.0f + (float)this.nowLevel(stack) / 100.0f)));
                    }
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                player.getAttributes().removeAttributeModifiers(this.ad(stack, this));
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        linkedHashMultimap.put(AttReg.effectNumber, (Object)new AttributeModifier(id, 9.0, AttributeModifier.Operation.ADD_VALUE));
        return linkedHashMultimap;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> ad(ItemStack stack, Terror terror) {
        HashMultimap modifiers = HashMultimap.create();
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            float s = 0.0f;
            if (compoundTag.getInt(drugTime) > 0) {
                s = compoundTag.getFloat(drugStronger);
            }
            modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)s, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifiers;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return !Handler.hascurio(slotContext.entity(), (Item)Items.biochemistry.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.1").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.2").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.3").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.4").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.5").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.6").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.7").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.8").withStyle(ChatFormatting.DARK_RED));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.9").withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.10").append(String.format("%.2f", Float.valueOf(50.0f * (1.0f + (float)this.nowLevel(stack) / 100.0f)))).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.11").append(String.format("%.2f", Float.valueOf(5.0f / (1.0f + (float)this.nowLevel(stack) / 100.0f)))).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.12").append(String.format("%.2f", Float.valueOf(400.0f * (1.0f + (float)this.nowLevel(stack) / 100.0f)))).withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.14").append(String.format("%.2f", Float.valueOf(350.0f / (1.0f + (float)this.nowLevel(stack) / 100.0f)))).withStyle(ChatFormatting.GOLD));
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.13").append(String.valueOf(compoundTag.getInt(drugSize))).withStyle(ChatFormatting.DARK_RED));
            float stronger = 50.0f * (1.0f + (float)this.nowLevel(stack) / 100.0f);
            float weak = compoundTag.getFloat(drugWeakness);
            tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.15").append(String.format("%.2f", Float.valueOf(stronger -= (weak /= 1.0f + (float)this.nowLevel(stack) / 100.0f)))).append("%").withStyle(ChatFormatting.GOLD));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.crazy_drug.tool.string.13").append(String.valueOf(0)).withStyle(ChatFormatting.DARK_RED));
        }
    }

    @Override
    public ResourceLocation image(@Nullable LivingEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/gui/tooltip/small_fire.png");
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 0, 255, 25);
    }

    @Override
    public int nowLevel(ItemStack stack) {
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            return compoundTag.getInt("SITheTerrorName");
        }
        return 0;
    }

    @Override
    public int maxLevel(ItemStack stack) {
        return 100;
    }
}

