/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.element;

import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Effects;
import com.ytgld.seeking_immortals.item.an_element.AllElement;
import com.ytgld.seeking_immortals.item.an_element.NightmareTooltip;
import com.ytgld.seeking_immortals.item.an_element.elements.Destiny;
import com.ytgld.seeking_immortals.item.an_element.extend.Element;
import com.ytgld.seeking_immortals.item.nightmare.extend.NightmareYTGLD;
import com.ytgld.seeking_immortals.item.nightmare.super_nightmare.NightmareBlackEye;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class Yoke
extends NightmareYTGLD
implements AllElement {
    public static final String destinySting = "destinySting";

    public boolean overrideOtherStackedOnMe(ItemStack me, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        @Nullable CompoundTag compoundTag = (CompoundTag)me.get(DataReg.tag);
        if (compoundTag != null) {
            if (other.getItem() instanceof NightmareBlackEye) {
                compoundTag.putInt(destinySting, compoundTag.getInt(destinySting) + 10);
                other.shrink(1);
                return true;
            }
        } else {
            me.set(DataReg.tag, (Object)new CompoundTag());
        }
        return false;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        super.curioTick(slotContext, stack);
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null && (livingEntity = slotContext.entity()) instanceof Player) {
            int element;
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide && player.tickCount % 10 == 1 && Handler.hascurio((LivingEntity)player, this) && (element = Handler.getElement(stack, this, destiny)) >= 10) {
                int lv = element / 10;
                if (lv > 9) {
                    lv = 9;
                }
                player.addEffect(new MobEffectInstance(Effects.the_yoke_of_war, 200, lv, false, false));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.yoke.tool.string").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.yoke.tool.string.1").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.translatable((String)"item.yoke.tool.string.2").withStyle(ChatFormatting.DARK_RED));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.nightmare_base.element.string").withStyle(ChatFormatting.DARK_RED));
            tooltipComponents.add((Component)Component.literal((String)""));
            tooltipComponents.add((Component)Component.translatable((String)"item.moonstone.nightmare_base_black_eye").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @Override
    public Map<Element, ResourceLocation> name() {
        HashMap<Element, ResourceLocation> map = new HashMap<Element, ResourceLocation>();
        map.put(destiny, Destiny.destiny);
        return map;
    }

    @Override
    public Map<Element, String> tooltip() {
        HashMap<Element, String> map = new HashMap<Element, String>();
        map.put(destiny, "\u547d\u8fd0\u4e4b\u773c");
        return map;
    }

    @Override
    public Map<Element, Integer> element(ItemStack stack) {
        HashMap<Element, Integer> map = new HashMap<Element, Integer>();
        @Nullable CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        int s = 0;
        if (compoundTag != null) {
            s = compoundTag.getInt(destinySting);
        }
        map.put(destiny, s);
        return map;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new NightmareTooltip(this, stack));
    }
}

