/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.fall;

import com.ytgld.seeking_immortals.event.old.NewEvent;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.item.nightmare.fall.FallItem;
import com.ytgld.seeking_immortals.renderer.light.Light;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import top.theillusivec4.curios.api.SlotContext;

public class AlchemyPot
extends FallItem {
    public static final String p1 = "PotionItem1";
    public static final String p1Time = "PotionItem1Time";
    public static final String p1Lvl = "PotionItem1Lvl";
    public static final String p2 = "PotionItem2";
    public static final String p2Time = "PotionItem2Time";
    public static final String p2Lvl = "PotionItem2vl";
    public static final String p3 = "PotionItem3";
    public static final String p3Time = "PotionItem3Time";
    public static final String p3Lvl = "PotionItem3vl";
    public static final String p4 = "PotionItem4";
    public static final String p4Time = "PotionItem4Time";
    public static final String p4Lvl = "PotionItem4vl";

    public boolean overrideOtherStackedOnMe(ItemStack me, ItemStack other, Slot p_150744_, ClickAction p_150745_, Player player, SlotAccess p_150747_) {
        CompoundTag compoundTag = (CompoundTag)me.get(DataReg.tag);
        if (compoundTag == null) {
            me.set(DataReg.tag, (Object)new CompoundTag());
        }
        if (p_150745_ == ClickAction.SECONDARY && p_150744_.allowModification(player)) {
            if (other.is(Items.WATER_BUCKET) && compoundTag != null) {
                compoundTag.getAllKeys().clear();
                p_150747_.set(Items.BUCKET.getDefaultInstance());
                return true;
            }
            if (other.getItem() instanceof PotionItem && compoundTag != null) {
                if (!player.getCooldowns().isOnCooldown((Item)this) && !compoundTag.getBoolean("111p1")) {
                    compoundTag.putBoolean("111p1", true);
                    this.addTag(p1, p1Time, p1Lvl, other, compoundTag);
                    player.getCooldowns().addCooldown((Item)this, 10);
                }
                if (!player.getCooldowns().isOnCooldown((Item)this) && !compoundTag.getBoolean("111p2") && compoundTag.getBoolean("111p1")) {
                    compoundTag.putBoolean("111p2", true);
                    this.addTag(p2, p2Time, p2Lvl, other, compoundTag);
                    player.getCooldowns().addCooldown((Item)this, 10);
                }
                if (!player.getCooldowns().isOnCooldown((Item)this) && !compoundTag.getBoolean("111p3") && compoundTag.getBoolean("111p2")) {
                    compoundTag.putBoolean("111p3", true);
                    this.addTag(p3, p3Time, p3Lvl, other, compoundTag);
                    player.getCooldowns().addCooldown((Item)this, 10);
                }
                if (!player.getCooldowns().isOnCooldown((Item)this) && !compoundTag.getBoolean("111p4") && compoundTag.getBoolean("111p3")) {
                    compoundTag.putBoolean("111p4", true);
                    this.addTag(p4, p4Time, p4Lvl, other, compoundTag);
                    player.getCooldowns().addCooldown((Item)this, 10);
                }
                if (compoundTag.getBoolean("111p4")) {
                    return false;
                }
                other.shrink(1);
                return true;
            }
        }
        return false;
    }

    public void addTag(String name, String time, String lvl, ItemStack me, CompoundTag compoundTag) {
        PotionContents potionContents = (PotionContents)me.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        potionContents.forEachEffect(mobEffectInstance -> {
            ResourceLocation resourceLocation = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffectInstance.getEffect().value()));
            if (resourceLocation != null && !((MobEffect)mobEffectInstance.getEffect().value()).isInstantenous()) {
                compoundTag.putFloat(time, (float)(mobEffectInstance.getDuration() + 600));
                compoundTag.putInt(lvl, mobEffectInstance.getAmplifier());
                compoundTag.putString(name, resourceLocation.toString());
            }
        });
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if (!slotContext.entity().level().isClientSide && slotContext.entity().tickCount % 20 == 1) {
            this.addEffect(compoundTag, slotContext.entity(), p1, p1Time, p1Lvl);
            this.addEffect(compoundTag, slotContext.entity(), p2, p2Time, p2Lvl);
            this.addEffect(compoundTag, slotContext.entity(), p3, p3Time, p3Lvl);
            this.addEffect(compoundTag, slotContext.entity(), p4, p4Time, p4Lvl);
        }
    }

    public void addEffect(CompoundTag compoundTag, LivingEntity entity, String name, String time, String level) {
        String p1Effect;
        if (compoundTag != null && !(p1Effect = compoundTag.getString(name)).isEmpty()) {
            String[] pats = p1Effect.split(":");
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)pats[0], (String)pats[1]);
            Optional effectReference = BuiltInRegistries.MOB_EFFECT.getHolder(resourceLocation);
            float getDuration = compoundTag.getFloat(time);
            if (!(getDuration > 0.0f)) {
                return;
            }
            compoundTag.putFloat(time, getDuration - 20.0f);
            int lvl = compoundTag.getInt(level);
            effectReference.ifPresent(mobEffectReference -> entity.addEffect(new MobEffectInstance(mobEffectReference.getDelegate(), 100, lvl)));
        }
    }

    public void addTip(List<Component> tooltipComponents, String Z) {
        int red = 255;
        int purple = 255;
        int g = (int)(255.0 * Math.sin(NewEvent.time / 200.0f));
        if ((g /= 2) < 0) {
            g = -g;
        }
        tooltipComponents.add((Component)Component.translatable((String)Z).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)Light.ARGB.color(255, red, g, purple)))));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        this.addTip(tooltipComponents, "item.alchemy_pot.tool.string.1");
        this.addTip(tooltipComponents, "item.alchemy_pot.tool.string.2");
        this.addTip(tooltipComponents, "item.alchemy_pot.tool.string.3");
        this.addTip(tooltipComponents, "item.alchemy_pot.tool.string.4");
        if (Screen.hasShiftDown()) {
            if (compoundTag != null) {
                tooltipComponents.add((Component)Component.literal((String)("effect: " + compoundTag.getString(p1))));
                tooltipComponents.add((Component)Component.literal((String)("duration: " + compoundTag.getFloat(p1Time))));
                tooltipComponents.add((Component)Component.literal((String)("lvl: " + compoundTag.getInt(p1Lvl))));
                tooltipComponents.add((Component)Component.literal((String)""));
                tooltipComponents.add((Component)Component.literal((String)("effect: " + compoundTag.getString(p2))));
                tooltipComponents.add((Component)Component.literal((String)("duration: " + compoundTag.getFloat(p2Time))));
                tooltipComponents.add((Component)Component.literal((String)("lvl: " + compoundTag.getInt(p2Lvl))));
                tooltipComponents.add((Component)Component.literal((String)""));
                tooltipComponents.add((Component)Component.literal((String)("effect: " + compoundTag.getString(p3))));
                tooltipComponents.add((Component)Component.literal((String)("duration: " + compoundTag.getFloat(p3Time))));
                tooltipComponents.add((Component)Component.literal((String)("lvl: " + compoundTag.getInt(p3Lvl))));
                tooltipComponents.add((Component)Component.literal((String)""));
                tooltipComponents.add((Component)Component.literal((String)("effect: " + compoundTag.getString(p4))));
                tooltipComponents.add((Component)Component.literal((String)("duration: " + compoundTag.getFloat(p4Time))));
                tooltipComponents.add((Component)Component.literal((String)("lvl: " + compoundTag.getInt(p4Lvl))));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.alchemy_pot.tool.string").withStyle(ChatFormatting.GRAY));
        }
    }
}

