/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.fall;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.event.old.NewEvent;
import com.ytgld.seeking_immortals.init.AttReg;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Effects;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.INightmare;
import com.ytgld.seeking_immortals.item.nightmare.tip.Godtip;
import com.ytgld.seeking_immortals.item.nightmare.tip.Terror;
import com.ytgld.seeking_immortals.renderer.MRender;
import com.ytgld.seeking_immortals.renderer.light.Light;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.common.CuriosRegistry;

public class TheDivineFallRing
extends Item
implements ICurioItem,
INightmare,
Godtip,
Terror {
    public static final String uDead = "undead";

    public TheDivineFallRing() {
        super(new Item.Properties().stacksTo(1).component(CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS, (Object)CurioAttributeModifiers.EMPTY).durability(1000000000).rarity(Rarity.UNCOMMON));
    }

    public static void exp(LivingExperienceDropEvent event) {
        Player player;
        Player player2 = event.getAttackingPlayer();
        if (player2 instanceof Player && Handler.hascurio((LivingEntity)(player = player2), (Item)Items.the_divine_fall_ring.get())) {
            event.setDroppedExperience(event.getDroppedExperience() * 2);
        }
    }

    public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext, ItemStack stack) {
        return 2;
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        return 2;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        linkedHashMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 10.0, AttributeModifier.Operation.ADD_VALUE));
        linkedHashMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 10.0, AttributeModifier.Operation.ADD_VALUE));
        linkedHashMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 10.0, AttributeModifier.Operation.ADD_VALUE));
        linkedHashMultimap.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return linkedHashMultimap;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (!slotContext.entity().level().isClientSide && slotContext.entity().tickCount < 20) {
            slotContext.entity().addEffect(new MobEffectInstance(Effects.invulnerable, 200, 0, false, false, false));
        }
        if (stack.get(DataReg.tag) == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
        if ((livingEntity = slotContext.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                float lv = player.getHealth() / player.getMaxHealth();
                int now = (int)(100.0f - (lv *= 100.0f));
                if (stack.get(DataReg.tag) == null) {
                    stack.set(DataReg.tag, (Object)new CompoundTag());
                }
                if (stack.get(DataReg.tag) != null) {
                    ((CompoundTag)stack.get(DataReg.tag)).putInt(uDead, now);
                }
                player.getAttributes().addTransientAttributeModifiers(this.ad(stack));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        slotContext.entity().getAttributes().removeAttributeModifiers(this.ad(stack));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> ad(ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (stack.get(DataReg.tag) != null) {
            int lvl = ((CompoundTag)stack.get(DataReg.tag)).getInt(uDead);
            float heal = 0.0085f * (float)lvl;
            float speed = 0.008f * (float)lvl;
            float damage = 0.0075f * (float)lvl;
            float attSpeed = 0.005f * (float)lvl;
            float armor = 0.0034999999f * (float)lvl;
            modifiers.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)heal, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)speed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)damage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)attSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.parse((String)("moonstone" + this.getDescriptionId())), (double)armor, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return modifiers;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        String tring1 = "item.the_divine_fall_ring.tool.string.1";
        String tring2 = "item.the_divine_fall_ring.tool.string.2";
        String tring3 = "item.the_divine_fall_ring.tool.string.3";
        String tring4 = "item.the_divine_fall_ring.tool.string.4";
        String tring5 = "item.the_divine_fall_ring.tool.string.5";
        String tring6 = "item.the_divine_fall_ring.tool.string.6";
        String tring7 = "item.the_divine_fall_ring.tool.string.7";
        this.addTip(tooltipComponents, tring1);
        this.addTip(tooltipComponents, tring2);
        this.addTip(tooltipComponents, tring3);
        this.addTip(tooltipComponents, tring4);
        this.addTip(tooltipComponents, tring5);
        this.addTip(tooltipComponents, tring6);
        this.addTip(tooltipComponents, tring7);
        tooltipComponents.add((Component)Component.translatable((String)"item.immortal.tool.string.5").withStyle(ChatFormatting.RED));
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Component component = super.getName(stack);
        MutableComponent co = component.copy();
        co.setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-65536)));
        return co;
    }

    public void addTip(List<Component> tooltipComponents, String Z) {
        int red = 255;
        int purple = 255;
        int g = (int)(255.0 * Math.sin(NewEvent.time / 200.0f));
        if ((g /= 2) < 0) {
            g = -g;
        }
        tooltipComponents.add((Component)Component.translatable((String)Z).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)Light.ARGB.color(255, red, g, purple)))));
    }

    @Override
    public ResourceLocation image(@Nullable LivingEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/gui/tooltip/fire.png");
    }

    @Override
    @Nullable
    public Map<Integer, Component> describe(ItemStack stack) {
        return null;
    }

    @Override
    public int maxLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public int nowLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean showFire(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isRot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTrail(ItemStack stack) {
        return false;
    }

    @Override
    public RenderType getTrailRenderType(ItemStack stack) {
        return MRender.light;
    }

    @Override
    public int color(ItemStack stack) {
        int red = 255;
        int purple = 255;
        int g = (int)(255.0 * Math.sin(NewEvent.time / 33.0f));
        if ((g /= 2) < 0) {
            g = -g;
        }
        return Light.ARGB.color(255, red, purple, g);
    }
}

