/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.super_nightmare;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.init.items.Items;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.item.nightmare.extend.MainNightmare;
import com.ytgld.seeking_immortals.item.nightmare.extend.NightmareYTGLD;
import com.ytgld.seeking_immortals.item.nightmare.extend.SuperNightmare;
import com.ytgld.seeking_immortals.item.nightmare.tip.AllTip;
import com.ytgld.seeking_immortals.item.nightmare.tip.ToolTip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class NightmareBlackEye
extends NightmareYTGLD
implements SuperNightmare,
AllTip,
MainNightmare {
    public static String destinyTag = "Destiny";

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).isEquipped((Item)Items.immortal.get())) {
                return true;
            }
            if (player.isCreative()) {
                return true;
            }
        }
        return false;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        CompoundTag compoundTag;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && this.look((player = (Player)livingEntity).level(), (LivingEntity)player) instanceof LivingEntity && (compoundTag = (CompoundTag)stack.get(DataReg.tag)) != null && !player.level().isClientSide && player.tickCount % 100 == 0) {
            compoundTag.putInt(destinyTag, compoundTag.getInt(destinyTag) + 1);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        CuriosApi.addSlotModifier((Multimap)linkedHashMultimap, (String)"nightmare", (ResourceLocation)ResourceLocation.parse((String)"nightmare_base_black_eyeadd_slot"), (double)3.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        return linkedHashMultimap;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, pTooltipComponents, tooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.nightmare_base_black_eye.tool.string").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.nightmare_base_black_eye.tool.string.1").withStyle(ChatFormatting.RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.moonstone.nightmare_base_black_eye_eye").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.moonstone.nightmare_base_black_eye_red").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.moonstone.nightmare_base_black_eye_heart").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.moonstone.tricky_puppets").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.nightmareeye.tool.string.2").withStyle(ChatFormatting.DARK_RED));
    }

    public Entity look(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new ToolTip(this, stack));
    }

    @Override
    public Map<Integer, String> tooltip() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5e26\u4e0a\u5b83 \u4f60\u5c06\u514d\u75ab\u9ed1\u6697");
        map.put(2, "\u5e26\u4e0a\u5b83 \u4f60\u5c06\u514d\u75ab\u5931\u660e");
        return map;
    }

    @Override
    public Map<Integer, String> element(ItemStack stack) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u5e26\u4e0a\u5b83 \u4f60\u5c06\u514d\u75ab\u9ed1\u6697");
        map.put(2, "\u5e26\u4e0a\u5b83 \u4f60\u5c06\u514d\u75ab\u5931\u660e");
        return map;
    }
}

