/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.super_nightmare.redemption;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.AttReg;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.NightmareYTGLD;
import com.ytgld.seeking_immortals.item.nightmare.extend.SuperNightmare;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class Hypocritical_self_esteem
extends NightmareYTGLD
implements SuperNightmare {
    public static final String MALICE_DIE = "HypocriticalSelfEsteem";

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide && Handler.hascurio((LivingEntity)player, (Item)Items.hypocritical_self_esteem.get())) {
                player.getAttributes().addTransientAttributeModifiers(this.Head(stack));
                int size = 0;
                Vec3 playerPos = player.position();
                int range = 24;
                List entities = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
                for (LivingEntity living : entities) {
                    if (living.is((Entity)player) || !living.isAlive() || living.tickCount % 30 != 0) continue;
                    living.level().playSound(null, living.getX(), living.getY(), living.getZ(), SoundEvents.PHANTOM_BITE, SoundSource.AMBIENT, 0.2f, 0.2f);
                    break;
                }
                for (LivingEntity living : entities) {
                    size = entities.size();
                    if (!Handler.hascurio((LivingEntity)player, (Item)Items.nightmare_base_black_eye.get()) || living.is((Entity)player) || !living.isAlive() || living.tickCount % 10 != 0) continue;
                    int l = entities.size() + 1;
                    if (l > 10) {
                        l = 10;
                    }
                    living.hurt(living.damageSources().magic(), (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) * (0.2f * (float)l));
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 2, false, false));
                    living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0, false, false));
                    living.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 300, 1, false, false));
                    living.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 2, false, false));
                    living.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 100, 3, false, false));
                    living.invulnerableTime = 0;
                    player.heal(2.0f);
                    break;
                }
                if (stack.get(DataReg.tag) != null) {
                    ((CompoundTag)stack.get(DataReg.tag)).putInt(MALICE_DIE, size);
                } else {
                    stack.set(DataReg.tag, (Object)new CompoundTag());
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getAttributes().removeAttributeModifiers(this.Head(stack));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"item.hypocritical_self_esteem.tool.string").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.literal((String)"+5%").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"effect.minecraft.regeneration").withStyle(ChatFormatting.RED)));
            tooltip.add((Component)Component.literal((String)"+5%").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"attribute.name.generic.attack_damage").withStyle(ChatFormatting.RED)));
            tooltip.add((Component)Component.literal((String)"+5%").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"attribute.name.generic.armor").withStyle(ChatFormatting.RED)));
            tooltip.add((Component)Component.literal((String)"+5%").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"attribute.name.generic.attack_speed").withStyle(ChatFormatting.RED)));
            tooltip.add((Component)Component.literal((String)"+5%").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)"attrib.seeking_immortals.critical").withStyle(ChatFormatting.RED)));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.hypocritical_self_esteem.tool.string.1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-2354116))));
            tooltip.add((Component)Component.translatable((String)"item.hypocritical_self_esteem.tool.string.2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-47223))));
            tooltip.add((Component)Component.translatable((String)"item.hypocritical_self_esteem.tool.string.3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-47223))));
            tooltip.add((Component)Component.translatable((String)"item.hypocritical_self_esteem.tool.string.4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-47223))));
        } else {
            tooltip.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.DARK_RED));
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> Head(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (stack.get(DataReg.tag) != null) {
            float s = ((CompoundTag)stack.get(DataReg.tag)).getInt(MALICE_DIE);
            if ((double)s > (Double)Config.SERVER.hypocritical_self_esteem.get()) {
                s = (float)Config.SERVER.hypocritical_self_esteem.getAsDouble();
            }
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)((s /= 100.0f) * 5.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            multimap.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)(s * 5.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)(s * 5.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            multimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)(s * 5.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            multimap.put(AttReg.cit, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)(s * 5.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return multimap;
    }
}

