/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.test_entity;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Lighting
extends ThrowableItemProjectile {
    public Lighting(EntityType<? extends Lighting> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        this.setNoGravity(true);
        if (this.tickCount == 1) {
            Vec3 playerPos = this.position();
            float range = 2.0f;
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity living : entities) {
                Entity entity;
                if (this.getOwner() == null || living.is(this.getOwner()) || !((entity = this.getOwner()) instanceof Player)) continue;
                Player player = (Player)entity;
                living.invulnerableTime = 0;
                living.hurt(living.damageSources().magic(), 3.0f + player.getMaxHealth() * 0.1f);
            }
        } else if (this.tickCount > 20) {
            this.discard();
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.IRON_SWORD;
    }
}

