/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.crafting;

import com.moonstone.moonstonemod.crafting.AllCrafting;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.DataReg;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class UniverseCrafting
extends CustomRecipe {
    private final CraftingBookCategory category;

    public UniverseCrafting(CraftingBookCategory category) {
        super(category);
        this.category = category;
    }

    @NotNull
    public CraftingBookCategory category() {
        return this.category;
    }

    public boolean matches(CraftingInput craftingInput, @NotNull Level level) {
        ItemStack itemStack;
        int i;
        boolean hasFirstItem = false;
        boolean hasSecondItem = false;
        int must = 0;
        ItemStack me = ItemStack.EMPTY;
        ItemStack other = ItemStack.EMPTY;
        for (i = 0; i < craftingInput.size(); ++i) {
            itemStack = craftingInput.getItem(i).copy();
            if (itemStack.isEmpty() || !itemStack.is((Item)Items.universe.get())) continue;
            if (itemStack.get(DataReg.tag) == null) {
                itemStack.set(DataReg.tag, (Object)new CompoundTag());
            }
            if (itemStack.get(DataReg.tag) == null || ((CompoundTag)itemStack.get(DataReg.tag)).getInt("doAsUniverse") >= 5) continue;
            me = itemStack;
            hasFirstItem = true;
            ++must;
        }
        for (i = 0; i < craftingInput.size(); ++i) {
            itemStack = craftingInput.getItem(i).copy();
            if (itemStack.is((Item)Items.universe.get()) || !BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace().equals("moonstone") || !(itemStack.getItem() instanceof ICurioItem)) continue;
            other = itemStack;
            hasSecondItem = true;
            ++must;
        }
        if (other == me) {
            return false;
        }
        return hasFirstItem && hasSecondItem && must == 2;
    }

    public void addTag(ItemStack itemStack) {
        if (itemStack.get(DataReg.tag) == null) {
            itemStack.set(DataReg.tag, (Object)new CompoundTag());
        }
        itemStack.get(DataReg.tag);
    }

    @NotNull
    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack universeItem = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemStack = craftingInput.getItem(i).copy();
            if (!itemStack.is((Item)Items.universe.get())) continue;
            this.addTag(itemStack);
            if (((CompoundTag)itemStack.get(DataReg.tag)).getInt("doAsUniverse") >= 5) continue;
            universeItem = itemStack;
            break;
        }
        if (universeItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (int j = 0; j < craftingInput.size(); ++j) {
            ItemStack other = craftingInput.getItem(j).copy();
            if (other.isEmpty() || !(other.getItem() instanceof ICurioItem) || !BuiltInRegistries.ITEM.getKey((Object)other.getItem()).getNamespace().equals("moonstone")) continue;
            String name = other.getItem().getDescriptionId();
            ((CompoundTag)universeItem.get(DataReg.tag)).putString(name, name);
            ((CompoundTag)universeItem.get(DataReg.tag)).putInt("doAsUniverse", ((CompoundTag)universeItem.get(DataReg.tag)).getInt("doAsUniverse") + 1);
        }
        return universeItem;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllCrafting.UniverseCrafting.get();
    }
}

