/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.nightmare;

import com.google.common.collect.ImmutableList;
import com.moonstone.moonstonemod.entity.nightmare.nightmare_giant;
import java.util.List;
import net.minecraft.client.animation.definitions.WardenAnimation;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class NModel<T extends nightmare_giant>
extends HierarchicalModel<T> {
    private final ModelPart root;
    public final ModelPart bone;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightTendril;
    public final ModelPart leftTendril;
    public final ModelPart leftLeg;
    public final ModelPart leftArm;
    public final ModelPart leftRibcage;
    public final ModelPart rightArm;
    public final ModelPart rightLeg;
    public final ModelPart rightRibcage;
    private final List<ModelPart> tendrilsLayerModelParts;
    private final List<ModelPart> heartLayerModelParts;
    private final List<ModelPart> bioluminescentLayerModelParts;
    private final List<ModelPart> pulsatingSpotsLayerModelParts;

    public NModel(ModelPart pRoot) {
        super(RenderType::entityCutoutNoCull);
        this.root = pRoot;
        this.bone = pRoot.getChild("bone");
        this.body = this.bone.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.bone.getChild("right_leg");
        this.leftLeg = this.bone.getChild("left_leg");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightTendril = this.head.getChild("right_tendril");
        this.leftTendril = this.head.getChild("left_tendril");
        this.rightRibcage = this.body.getChild("right_ribcage");
        this.leftRibcage = this.body.getChild("left_ribcage");
        this.tendrilsLayerModelParts = ImmutableList.of((Object)this.leftTendril, (Object)this.rightTendril);
        this.heartLayerModelParts = ImmutableList.of((Object)this.body);
        this.bioluminescentLayerModelParts = ImmutableList.of((Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.pulsatingSpotsLayerModelParts = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        float f = pAgeInTicks - (float)((nightmare_giant)((Object)pEntity)).tickCount;
        this.animateHeadLookTarget(pNetHeadYaw, pHeadPitch);
        this.animateWalk(pLimbSwing, pLimbSwingAmount);
        this.animateIdlePose(pAgeInTicks);
        this.animateTendrils(pEntity, pAgeInTicks, f);
        this.animate(((nightmare_giant)((Object)pEntity)).attackAnimationState, WardenAnimation.WARDEN_ATTACK, pAgeInTicks);
        this.animate(((nightmare_giant)((Object)pEntity)).diggingAnimationState, WardenAnimation.WARDEN_DIG, pAgeInTicks);
        this.animate(((nightmare_giant)((Object)pEntity)).emergeAnimationState, WardenAnimation.WARDEN_EMERGE, pAgeInTicks);
        this.animate(((nightmare_giant)((Object)pEntity)).roarAnimationState, WardenAnimation.WARDEN_ROAR, pAgeInTicks);
        this.animate(((nightmare_giant)((Object)pEntity)).sniffAnimationState, WardenAnimation.WARDEN_SNIFF, pAgeInTicks);
    }

    private void animateHeadLookTarget(float pYaw, float pPitch) {
        this.head.xRot = pPitch * ((float)Math.PI / 180);
        this.head.yRot = pYaw * ((float)Math.PI / 180);
        this.head.xRot -= 0.61086524f;
    }

    private void animateIdlePose(float pAgeInTicks) {
        float f = pAgeInTicks * 0.1f;
        float f1 = Mth.cos((float)f);
        float f2 = Mth.sin((float)f);
        this.head.zRot += 0.06f * f1;
        this.head.xRot += 0.06f * f2;
        this.body.zRot += 0.025f * f2;
        this.body.xRot += 0.025f * f1;
    }

    private void animateWalk(float pLimbSwing, float pLimbSwingAmount) {
        float f = Math.min(0.5f, 3.0f * pLimbSwingAmount);
        float f1 = pLimbSwing * 0.8662f;
        float f2 = Mth.cos((float)f1);
        float f3 = Mth.sin((float)f1);
        float f4 = Math.min(0.35f, f);
        this.head.zRot += 0.3f * f3 * f;
        this.head.xRot += 1.2f * Mth.cos((float)(f1 + 1.5707964f)) * f4;
        this.body.zRot = 0.1f * f3 * f;
        this.body.xRot = 1.0f * f2 * f4;
        this.body.y += 1.5f;
        this.leftLeg.xRot = 1.0f * f2 * f;
        this.rightLeg.xRot = 1.0f * Mth.cos((float)(f1 + (float)Math.PI)) * f;
        this.leftArm.xRot = -(0.8f * f2 * f);
        this.leftArm.zRot = 0.0f;
        this.rightArm.xRot = -(0.8f * f3 * f);
        this.rightArm.zRot = 0.0f;
        this.body.xRot += 0.61086524f;
        this.leftLeg.z += 5.0f;
        this.rightLeg.z += 5.0f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.leftArm.yRot = 0.0f;
        this.leftArm.z = 1.0f;
        this.leftArm.x = 13.0f;
        this.leftArm.y = -13.0f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.z = 1.0f;
        this.rightArm.x = -13.0f;
        this.rightArm.y = -13.0f;
        this.leftArm.xRot -= 0.61086524f;
        this.rightArm.xRot -= 0.61086524f;
    }

    private void animateTendrils(T pEntity, float pAgeInTicks, float pPartialTick) {
        float f;
        this.leftTendril.xRot = f = ((nightmare_giant)((Object)pEntity)).getTendrilAnimation(pPartialTick) * (float)(Math.cos((double)pAgeInTicks * 2.25) * Math.PI * (double)0.1f);
        this.rightTendril.xRot = -f;
    }

    public ModelPart root() {
        return this.root;
    }

    public List<ModelPart> getTendrilsLayerModelParts() {
        return this.tendrilsLayerModelParts;
    }

    public List<ModelPart> getHeartLayerModelParts() {
        return this.heartLayerModelParts;
    }

    public List<ModelPart> getBioluminescentLayerModelParts() {
        return this.bioluminescentLayerModelParts;
    }

    public List<ModelPart> getPulsatingSpotsLayerModelParts() {
        return this.pulsatingSpotsLayerModelParts;
    }
}

