/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.mixin.t;

import com.mojang.blaze3d.vertex.PoseStack;
import com.moonstone.tbl.client.handler.ShaderHandler;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Nullable
    private PostChain transparencyChain;

    @Inject(method={"renderDebug"}, at={@At(value="HEAD")}, remap=false)
    public void renderDebugHook(PoseStack poseStack, MultiBufferSource buffer, Camera camera, CallbackInfo ci) {
        ShaderHandler.onPreRenderDebug(poseStack, buffer, camera);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")}, remap=false)
    public void renderLevel(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        float f = deltaTracker.getGameTimeDeltaPartialTick(false);
        ShaderHandler.renderWorldShader(f);
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="HEAD")}, remap=false)
    public void translucentPatcherStart(RenderType renderType, double x, double y, double z, Matrix4f frustrumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (renderType != RenderType.translucent() || this.transparencyChain != null) {
            return;
        }
        ShaderHandler.onPreTranslucentBatch();
    }

    @Inject(method={"renderSectionLayer"}, at={@At(value="RETURN")}, remap=false)
    public void translucentPatcherEnd(RenderType renderType, double x, double y, double z, Matrix4f frustrumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (renderType != RenderType.translucent() || this.transparencyChain != null) {
            return;
        }
        ShaderHandler.onPostTranslucentBatch();
    }
}

