/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare.base;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.init.AttReg;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.SuperNightmare;
import com.ytgld.seeking_immortals.item.nightmare.extend.nightmare;
import com.ytgld.seeking_immortals.item.nightmare.tip.AllTip;
import com.ytgld.seeking_immortals.item.nightmare.tip.ToolTip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class blood_god
extends nightmare
implements SuperNightmare,
AllTip {
    public static final int TIME = 200;
    public static final String bloodTime = "bloodTime";
    public static final String bloodDamage = "bloodDamage";
    public static final String giveName_kill = "giveName_kill";
    public static final String giveName_heal = "giveName_heal";
    public static final String giveName_damage = "giveName_damage";
    public static final String give_End = "give_End";

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new ToolTip(this, stack));
    }

    public static void hurtOfBlood(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity;
        if (event.getItem().getUseAnimation() == UseAnim.DRINK && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        CompoundTag compoundTag;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (!stack.is((Item)Items.blood_god.get()) || (compoundTag = (CompoundTag)stack.get(DataReg.tag)) == null) continue;
                        event.setDuration((int)((float)event.getDuration() * 0.7f));
                        if (player.getCooldowns().isOnCooldown((Item)Items.blood_god.get()) || !(compoundTag.getFloat(bloodDamage) > 0.0f) || !(event.getItem().getItem() instanceof PotionItem)) continue;
                        compoundTag.putFloat(bloodDamage, compoundTag.getFloat(bloodDamage) * 0.75f);
                        player.getCooldowns().addCooldown((Item)Items.blood_god.get(), 600);
                    }
                }
            });
        }
    }

    public static void hurtOfBlood(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity;
        if (!event.getSource().is(DamageTypes.GENERIC_KILL) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        float s;
                        CompoundTag compoundTag;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (!stack.is((Item)Items.blood_god.get()) || (compoundTag = (CompoundTag)stack.get(DataReg.tag)) == null || (s = event.getNewDamage() - 5.0f) <= 5.0f) continue;
                        compoundTag.putFloat(bloodDamage, compoundTag.getFloat(bloodDamage) + s);
                        compoundTag.putInt(bloodTime, 200);
                        event.setNewDamage(5.0f);
                    }
                }
            });
        }
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            return compoundTag.getInt(bloodTime) <= 0;
        }
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null) {
                if (compoundTag.getInt(bloodTime) <= 0) {
                    compoundTag.putFloat(bloodDamage, 0.0f);
                }
                if (compoundTag.getInt(bloodDamage) <= 0) {
                    compoundTag.putFloat(bloodTime, 0.0f);
                }
                if (player.isDeadOrDying()) {
                    compoundTag.putFloat(bloodDamage, 0.0f);
                    compoundTag.putFloat(bloodTime, 0.0f);
                }
                if (!player.level().isClientSide && player.tickCount % 20 == 1 && compoundTag.getInt(bloodTime) > 0 && compoundTag.getFloat(bloodDamage) > 0.0f) {
                    compoundTag.putInt(bloodTime, compoundTag.getInt(bloodTime) - 20);
                    float dmg = compoundTag.getFloat(bloodDamage) / 10.0f;
                    compoundTag.putFloat(bloodDamage, compoundTag.getFloat(bloodDamage) - dmg);
                    player.hurt(player.damageSources().genericKill(), dmg);
                }
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        linkedHashMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(id, 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        linkedHashMultimap.put(AttReg.heal, (Object)new AttributeModifier(id, 0.4, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return linkedHashMultimap;
    }

    @Override
    public Map<Integer, String> tooltip() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u8840\u796d\u8840\u795e\uff0c\u9885\u732e\u9885\u5ea7");
        map.put(2, "Blood for the Blood God");
        return map;
    }

    @Override
    @Nullable
    public Map<Integer, Component> describe(ItemStack stack) {
        HashMap<Integer, Component> map = new HashMap<Integer, Component>();
        map.put(1, (Component)Component.translatable((String)"curse.seeking_immortals.string").append(" ").withStyle(ChatFormatting.RED));
        return map;
    }

    @Override
    public int maxLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public int nowLevel(ItemStack stack) {
        return 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, pTooltipComponents, tooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.1").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.2").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.3").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.4").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.5").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.6").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.7").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.blood_god.tool.string.9").withStyle(ChatFormatting.GOLD));
    }

    @Override
    public Map<Integer, String> element(ItemStack stack) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u8840\u796d\u8840\u795e\uff0c\u9885\u732e\u9885\u5ea7");
        map.put(2, "Blood for the Blood God");
        return map;
    }
}

