/*
 * Decompiled with CFR 0.152.
 */
package se.itssimple.obsidianweave.data;

import java.util.ArrayList;
import java.util.List;
import se.itssimple.obsidianweave.data.ConfigEntry;

public class ConfigBuilder {
    private final List<ConfigEntry<?>> entries = new ArrayList();
    private final String modId;

    public ConfigBuilder(String modId) {
        this.modId = modId;
    }

    public <T> ConfigEntry<T> add(ConfigEntry<T> entry) {
        this.entries.add(entry);
        return entry;
    }

    public List<ConfigEntry<?>> getEntries() {
        return this.entries;
    }

    private String getNameLangKey(String key) {
        return "config." + this.modId + ".entry." + key;
    }

    private String getCommentLangKey(String key) {
        return this.getNameLangKey(key) + ".tooltip";
    }

    public ConfigEntry<Boolean> define(String key, boolean defaultValue, String nameLangKey, String commentLangKey) {
        ConfigEntry<Boolean> entry = new ConfigEntry<Boolean>(key, () -> defaultValue, Boolean.class).setNameLangKey(nameLangKey).setCommentLangKey(commentLangKey);
        return this.add(entry);
    }

    public ConfigEntry<Boolean> define(String key, boolean defaultValue) {
        return this.define(key, defaultValue, this.getNameLangKey(key), this.getCommentLangKey(key));
    }

    public ConfigEntry<String> define(String key, String defaultValue, String nameLangKey, String commentLangKey) {
        ConfigEntry<String> entry = new ConfigEntry<String>(key, () -> defaultValue, String.class).setNameLangKey(nameLangKey).setCommentLangKey(commentLangKey);
        return this.add(entry);
    }

    public ConfigEntry<String> define(String key, String defaultValue) {
        return this.define(key, defaultValue, this.getNameLangKey(key), this.getCommentLangKey(key));
    }

    public ConfigEntry<Integer> define(String key, Integer defaultValue, String nameLangKey, String commentLangKey) {
        ConfigEntry<Integer> entry = new ConfigEntry<Integer>(key, () -> defaultValue, Integer.class).setNameLangKey(nameLangKey).setCommentLangKey(commentLangKey);
        return this.add(entry);
    }

    public ConfigEntry<Integer> define(String key, Integer defaultValue) {
        return this.define(key, defaultValue, this.getNameLangKey(key), this.getCommentLangKey(key));
    }

    public ConfigEntry<Double> define(String key, Double defaultValue, String nameLangKey, String commentLangKey) {
        ConfigEntry<Double> entry = new ConfigEntry<Double>(key, () -> defaultValue, Double.class).setNameLangKey(nameLangKey).setCommentLangKey(commentLangKey);
        return this.add(entry);
    }

    public ConfigEntry<Double> define(String key, Double defaultValue) {
        return this.define(key, defaultValue, this.getNameLangKey(key), this.getCommentLangKey(key));
    }
}

