/*
 * Decompiled with CFR 0.152.
 */
package se.itssimple.obsidianweave.data;

import java.util.function.Supplier;
import se.itssimple.obsidianweave.services.Services;

public class ConfigEntry<T> {
    private final String key;
    private final Supplier<T> defaultValueSupplier;
    private final Class<T> type;
    private String nameLangKey;
    private String commentLangKey;
    private Object platformBinding;
    private T internalCachedValue;

    public ConfigEntry(String key, Supplier<T> defaultValueSupplier, Class<T> type) {
        this.key = key;
        this.defaultValueSupplier = defaultValueSupplier;
        this.type = type;
        this.internalCachedValue = defaultValueSupplier.get();
    }

    public String getKey() {
        return this.key;
    }

    public Supplier<T> getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValueSupplier.get();
    }

    public String getNameLangKey() {
        return this.nameLangKey == null ? "config.entry." + this.key : this.nameLangKey;
    }

    public ConfigEntry<T> setNameLangKey(String nameLangKey) {
        this.nameLangKey = nameLangKey;
        return this;
    }

    public String getCommentLangKey() {
        return this.commentLangKey == null ? this.getNameLangKey() + ".tooltip" : this.commentLangKey;
    }

    public ConfigEntry<T> setCommentLangKey(String commentLangKey) {
        this.commentLangKey = commentLangKey;
        return this;
    }

    public T getValue() {
        return Services.PLATFORMHELPER.getValue(this);
    }

    public void setValue(T value) {
        Services.PLATFORMHELPER.setValue(this, value);
    }

    public T getInternalCachedValue() {
        return this.internalCachedValue;
    }

    public void setInternalCachedValue(T internalCachedValue) {
        this.internalCachedValue = internalCachedValue;
    }

    public Object getPlatformBinding() {
        return this.platformBinding;
    }

    public void setPlatformBinding(Object platformBinding) {
        this.platformBinding = platformBinding;
    }
}

