/*
 * Decompiled with CFR 0.152.
 */
package se.itssimple.obsidianweave.data;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import se.itssimple.obsidianweave.data.ConfigEntry;

public class ConfigHolder {
    private final String modId;
    private final Map<String, ConfigEntry<?>> configEntryMap;
    private final List<ConfigEntry<?>> configEntryList;

    public ConfigHolder(String modId, List<ConfigEntry<?>> configEntryList) {
        this.modId = modId;
        this.configEntryList = List.copyOf(configEntryList);
        this.configEntryMap = configEntryList.stream().collect(Collectors.toMap(ConfigEntry::getKey, Function.identity()));
    }

    public String getModId() {
        return this.modId;
    }

    public List<ConfigEntry<?>> getAllEntries() {
        return this.configEntryList;
    }

    public <T> Optional<ConfigEntry<T>> getEntry(String key) {
        ConfigEntry<?> entry = this.configEntryMap.get(key);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    public boolean getBoolean(String key) {
        return this.getEntry(key).map(e -> (Boolean)e.getValue()).orElse(false);
    }

    public Integer getInteger(String key) {
        return this.getEntry(key).map(e -> (Integer)e.getValue()).orElse(0);
    }

    public String getString(String key) {
        return this.getEntry(key).map(e -> (String)e.getValue()).orElse("");
    }

    public Double getDouble(String key) {
        return this.getEntry(key).map(e -> (Double)e.getValue()).orElse(0.0);
    }
}

