/*
 * Decompiled with CFR 0.152.
 */
package se.itssimple.obsidianweave.fabric.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import se.itssimple.obsidianweave.ModCommon;
import se.itssimple.obsidianweave.data.ConfigEntry;
import se.itssimple.obsidianweave.data.ConfigHolder;
import se.itssimple.obsidianweave.data.Constants;
import se.itssimple.obsidianweave.platform.IPlatformConfigHelper;

public class FabricPlatformHelper
implements IPlatformConfigHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private Path configRootPath;

    @Override
    public void initialize(String modId, String configSubDirectory) {
        if (ModCommon.CONFIG_DEBUG_LOGGING.booleanValue()) {
            Constants.LOG.info("Initializing Fabric config for mod {}", (Object)modId);
        }
        this.configRootPath = FabricLoader.getInstance().getConfigDir().resolve(configSubDirectory);
        try {
            Files.createDirectories(this.configRootPath, new FileAttribute[0]);
            Constants.LOG.info("Config directory: {}", (Object)this.configRootPath);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to create config directory: {}", (Object)this.configRootPath, (Object)e);
        }
    }

    private Path getConfigFilePath(ConfigHolder holder) {
        return this.configRootPath.resolve(holder.getModId() + ".json");
    }

    private String findModIdForEntry(ConfigEntry<?> entry) {
        for (ConfigHolder holder : ModCommon.getAllConfigs().values()) {
            if (!holder.getEntry(entry.getKey()).isPresent()) continue;
            return holder.getModId();
        }
        return null;
    }

    @Override
    public void register(ConfigHolder holder) {
    }

    @Override
    public void load(ConfigHolder holder) {
        Path configPath;
        if (ModCommon.CONFIG_DEBUG_LOGGING.booleanValue()) {
            Constants.LOG.info("Loading config for mod {}", (Object)holder.getModId());
        }
        if (Files.exists(configPath = this.getConfigFilePath(holder), new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    return;
                }
                for (ConfigEntry<?> entry : holder.getAllEntries()) {
                    if (json.has(entry.getKey())) {
                        JsonElement element = json.get(entry.getKey());
                        Object value = null;
                        try {
                            if (entry.getType() == Boolean.class && element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                                value = element.getAsBoolean();
                            } else if (entry.getType() == Integer.class && element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                                value = element.getAsInt();
                            } else if (entry.getType() == Double.class && element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                                value = element.getAsDouble();
                            } else if (entry.getType() == String.class && element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                                value = element.getAsString();
                            }
                            if (value != null) {
                                this.setValueUnsafe(entry, value);
                                continue;
                            }
                            Constants.LOG.warn("Type mismatch or invalid type for config key '{}' in mod '{}'. Using default.", (Object)entry.getKey(), (Object)holder.getModId());
                            this.resetToDefaultUnsafe(entry);
                        }
                        catch (Exception e) {
                            Constants.LOG.warn("Error parsing value for config key '{}' in mod '{}'. Using default. Error: {}", new Object[]{entry.getKey(), holder.getModId(), e.getMessage()});
                            this.resetToDefaultUnsafe(entry);
                        }
                        continue;
                    }
                    this.resetToDefaultUnsafe(entry);
                }
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to read config file: {}", (Object)configPath, (Object)e);
            }
        } else {
            holder.getAllEntries().forEach(this::resetToDefaultUnsafe);
            this.save(holder);
        }
        if (ModCommon.CONFIG_DEBUG_LOGGING.booleanValue()) {
            Constants.LOG.info("Config loaded for mod {}", (Object)holder.getModId());
        }
    }

    @Override
    public void save(ConfigHolder holder) {
        Path configPath = this.getConfigFilePath(holder);
        JsonObject json = new JsonObject();
        for (ConfigEntry<?> entry : holder.getAllEntries()) {
            json.add("_comment_" + entry.getKey(), (JsonElement)new JsonPrimitive("# " + class_1074.method_4662((String)entry.getCommentLangKey(), (Object[])new Object[0])));
            json.add("_type_" + entry.getKey(), (JsonElement)new JsonPrimitive("# " + String.valueOf(entry.getType())));
            Object value = entry.getInternalCachedValue();
            if (value instanceof Boolean) {
                json.addProperty(entry.getKey(), (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                json.addProperty(entry.getKey(), (Number)((Integer)value));
                continue;
            }
            if (value instanceof Double) {
                json.addProperty(entry.getKey(), (Number)((Double)value));
                continue;
            }
            if (!(value instanceof String)) continue;
            json.addProperty(entry.getKey(), (String)value);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save config for {}: {}", new Object[]{holder.getModId(), configPath, e});
        }
    }

    private <T> void setValueUnsafe(ConfigEntry<?> rawEntry, T value) {
        ConfigEntry<?> entry = rawEntry;
        entry.setInternalCachedValue(value);
    }

    private void resetToDefaultUnsafe(ConfigEntry<?> rawEntry) {
        this.setValueUnsafe(rawEntry, rawEntry.getDefaultValue());
    }

    @Override
    public <T> T getValue(ConfigEntry<T> entry) {
        return entry.getValue();
    }

    @Override
    public <T> void setValue(ConfigEntry<T> entry, T value) {
        entry.setInternalCachedValue(value);
        ModCommon.getConfig(this.findModIdForEntry(entry)).ifPresent(this::save);
    }
}

