/*
 * Decompiled with CFR 0.152.
 */
package net.eightyseven.craftytools.network;

import java.util.function.Supplier;
import net.eightyseven.craftytools.CraftytoolsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CraftytoolsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CraftytoolsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.gentle_shears_cooldown = message.data.gentle_shears_cooldown;
                    variables.wicked_shears_cooldown = message.data.wicked_shears_cooldown;
                    variables.selected_villager_UUID = message.data.selected_villager_UUID;
                    variables.soft_touch_unlocked = message.data.soft_touch_unlocked;
                    variables.shadow_snip_unlocked = message.data.shadow_snip_unlocked;
                    variables.new_trade_path_unlocked = message.data.new_trade_path_unlocked;
                    variables.torch_placer_cooldown = message.data.torch_placer_cooldown;
                    variables.torch_placer_torch_placed = message.data.torch_placer_torch_placed;
                    variables.torch_placer_last_torch_Y = message.data.torch_placer_last_torch_Y;
                    variables.torch_placer_last_torch_X = message.data.torch_placer_last_torch_X;
                    variables.torch_placer_last_torch_Z = message.data.torch_placer_last_torch_Z;
                    variables.torch_placer_empty = message.data.torch_placer_empty;
                    variables.let_there_be_light_unlocked = message.data.let_there_be_light_unlocked;
                    variables.villagers_wand_follow_mode = message.data.villagers_wand_follow_mode;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double gentle_shears_cooldown = 0.0;
        public double wicked_shears_cooldown = 0.0;
        public String selected_villager_UUID = "\"\"";
        public boolean soft_touch_unlocked = false;
        public boolean shadow_snip_unlocked = false;
        public boolean new_trade_path_unlocked = false;
        public double torch_placer_cooldown = 0.0;
        public boolean torch_placer_torch_placed = false;
        public double torch_placer_last_torch_Y = 0.0;
        public double torch_placer_last_torch_X = 0.0;
        public double torch_placer_last_torch_Z = 0.0;
        public boolean torch_placer_empty = false;
        public boolean let_there_be_light_unlocked = false;
        public boolean villagers_wand_follow_mode = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CraftytoolsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("gentle_shears_cooldown", this.gentle_shears_cooldown);
            nbt.m_128347_("wicked_shears_cooldown", this.wicked_shears_cooldown);
            nbt.m_128359_("selected_villager_UUID", this.selected_villager_UUID);
            nbt.m_128379_("soft_touch_unlocked", this.soft_touch_unlocked);
            nbt.m_128379_("shadow_snip_unlocked", this.shadow_snip_unlocked);
            nbt.m_128379_("new_trade_path_unlocked", this.new_trade_path_unlocked);
            nbt.m_128347_("torch_placer_cooldown", this.torch_placer_cooldown);
            nbt.m_128379_("torch_placer_torch_placed", this.torch_placer_torch_placed);
            nbt.m_128347_("torch_placer_last_torch_Y", this.torch_placer_last_torch_Y);
            nbt.m_128347_("torch_placer_last_torch_X", this.torch_placer_last_torch_X);
            nbt.m_128347_("torch_placer_last_torch_Z", this.torch_placer_last_torch_Z);
            nbt.m_128379_("torch_placer_empty", this.torch_placer_empty);
            nbt.m_128379_("let_there_be_light_unlocked", this.let_there_be_light_unlocked);
            nbt.m_128379_("villagers_wand_follow_mode", this.villagers_wand_follow_mode);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.gentle_shears_cooldown = nbt.m_128459_("gentle_shears_cooldown");
            this.wicked_shears_cooldown = nbt.m_128459_("wicked_shears_cooldown");
            this.selected_villager_UUID = nbt.m_128461_("selected_villager_UUID");
            this.soft_touch_unlocked = nbt.m_128471_("soft_touch_unlocked");
            this.shadow_snip_unlocked = nbt.m_128471_("shadow_snip_unlocked");
            this.new_trade_path_unlocked = nbt.m_128471_("new_trade_path_unlocked");
            this.torch_placer_cooldown = nbt.m_128459_("torch_placer_cooldown");
            this.torch_placer_torch_placed = nbt.m_128471_("torch_placer_torch_placed");
            this.torch_placer_last_torch_Y = nbt.m_128459_("torch_placer_last_torch_Y");
            this.torch_placer_last_torch_X = nbt.m_128459_("torch_placer_last_torch_X");
            this.torch_placer_last_torch_Z = nbt.m_128459_("torch_placer_last_torch_Z");
            this.torch_placer_empty = nbt.m_128471_("torch_placer_empty");
            this.let_there_be_light_unlocked = nbt.m_128471_("let_there_be_light_unlocked");
            this.villagers_wand_follow_mode = nbt.m_128471_("villagers_wand_follow_mode");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("craftytools", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.selected_villager_UUID = original.selected_villager_UUID;
            clone.soft_touch_unlocked = original.soft_touch_unlocked;
            clone.shadow_snip_unlocked = original.shadow_snip_unlocked;
            clone.new_trade_path_unlocked = original.new_trade_path_unlocked;
            clone.torch_placer_last_torch_Y = original.torch_placer_last_torch_Y;
            clone.torch_placer_last_torch_X = original.torch_placer_last_torch_X;
            clone.torch_placer_last_torch_Z = original.torch_placer_last_torch_Z;
            clone.torch_placer_empty = original.torch_placer_empty;
            clone.let_there_be_light_unlocked = original.let_there_be_light_unlocked;
            clone.villagers_wand_follow_mode = original.villagers_wand_follow_mode;
            if (!event.isWasDeath()) {
                clone.gentle_shears_cooldown = original.gentle_shears_cooldown;
                clone.wicked_shears_cooldown = original.wicked_shears_cooldown;
                clone.torch_placer_cooldown = original.torch_placer_cooldown;
                clone.torch_placer_torch_placed = original.torch_placer_torch_placed;
            }
        }
    }
}

