/*
 * Decompiled with CFR 0.152.
 */
package tn.nightbeam.fishermanhouse.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import tn.nightbeam.fishermanhouse.world.structures.FishermanHouseModStructureBase;
import tn.nightbeam.fishermanhouse.world.structures.FishermanHouseStructure;

@Mod.EventBusSubscriber
public class FishermanHouseModStructures {
    public static final DeferredRegister<StructureFeature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"fisherman_house");
    private static final List<StructureRegistration> STRUCTURE_REGISTRATIONS = new ArrayList<StructureRegistration>();
    public static final RegistryObject<FishermanHouseModStructureBase> FISHERMAN_HOUSE = FishermanHouseModStructures.register("fisherman_house", FishermanHouseStructure::new);

    private static RegistryObject<FishermanHouseModStructureBase> register(String registryname, Supplier<FishermanHouseModStructureBase> structure) {
        StructureRegistration structureRegistration = new StructureRegistration((RegistryObject<FishermanHouseModStructureBase>)REGISTRY.register(registryname, structure));
        STRUCTURE_REGISTRATIONS.add(structureRegistration);
        return structureRegistration.structure();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
            FishermanHouseModStructureBase structure = (FishermanHouseModStructureBase)registration.structure().get();
            if (structure.getBiomes() != null && !structure.getBiomes().contains(event.getName())) continue;
            event.getGeneration().getStructures().add(() -> structure.configuredFeature());
        }
    }

    @SubscribeEvent
    public static void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)levelAccessor;
            if (serverWorld.m_7726_().m_8481_() instanceof FlatLevelSource && serverWorld.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<FishermanHouseModStructureBase, StructureFeatureConfiguration> tempMap = new HashMap<FishermanHouseModStructureBase, StructureFeatureConfiguration>(serverWorld.m_7726_().f_8328_.m_62205_().m_64590_());
            for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
                FishermanHouseModStructureBase structure = (FishermanHouseModStructureBase)registration.structure().get();
                if (structure.getDimensions() != null && !structure.getDimensions().contains(serverWorld.m_46472_())) {
                    tempMap.remove((Object)structure);
                    continue;
                }
                tempMap.putIfAbsent(structure, (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)structure));
            }
            serverWorld.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
        }
    }

    private record StructureRegistration(RegistryObject<FishermanHouseModStructureBase> structure) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class InitClass {
        private InitClass() {
        }

        @SubscribeEvent
        public static void init(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                for (StructureRegistration registration : STRUCTURE_REGISTRATIONS) {
                    FishermanHouseModStructureBase structure = (FishermanHouseModStructureBase)registration.structure().get();
                    StructureFeatureConfiguration configuration = structure.getStructureFeatureConfiguration();
                    String id = structure.getRegistryName().toString();
                    StructureFeature.f_67012_.put((Object)id, (Object)structure);
                    if (structure.isSurroundedByLand()) {
                        StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add((Object)structure).build();
                    }
                    StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put((Object)structure, (Object)configuration).build();
                    BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
                        Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
                        if (structureMap instanceof ImmutableMap) {
                            HashMap<FishermanHouseModStructureBase, StructureFeatureConfiguration> tempMap = new HashMap<FishermanHouseModStructureBase, StructureFeatureConfiguration>(structureMap);
                            tempMap.put(structure, configuration);
                            ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
                        } else {
                            structureMap.put(structure, configuration);
                        }
                    });
                    Registry.m_122961_((Registry)BuiltinRegistries.f_123862_, (String)id, structure.configuredFeature());
                }
            });
        }
    }
}

