/*
 * Decompiled with CFR 0.152.
 */
package com.github.wyzzard225.crosshairfx.client;

import com.github.wyzzard225.crosshairfx.client.CrosshairRenderer;
import com.github.wyzzard225.settingsmanager.client.Settings;
import net.fabricmc.api.ClientModInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrosshairfxClient
implements ClientModInitializer {
    public static final Logger console = LogManager.getLogger((String)"CrosshairFX");
    public static Settings settings;

    public void onInitializeClient() {
        console.info("[CrosshairFX] Loading config...");
        settings = new Settings().setup("CrosshairFX", "CrosshairFX");
        settings.loadFromFile();
        CrosshairfxClient.createConfig();
        settings = settings.cleanup();
        console.info("CrosshairFX is now loaded!");
    }

    private static void createConfig() {
        settings.addSlider("chromaDuration", "CrosshairFX Settings", "Crosshair Color", 4.0f, "Chroma Speed", "The number of seconds for each loop of the chroma effect", 0.1f, 20.0f, 0.1f);
        settings.add("crosshairChroma", "CrosshairFX Settings", "Crosshair Color", false, "Chroma Crosshair", "Enables an animated rainbow effect for the crosshair", Settings.BooleanFormat.ONOFF);
        settings.addSlider("crosshairLength", "CrosshairFX Settings", "Crosshair Shape", 4, "Crosshair Length", "The length of each line in the crosshair", 1, 100, 1);
        settings.addSlider("crosshairThickness", "CrosshairFX Settings", "Crosshair Shape", 1, "Crosshair Thickness", "The thickness of each line in the crosshair", 1, 20, 1);
        settings.add("crosshairShape", "CrosshairFX Settings", "Crosshair Shape", (Enum)CrosshairRenderer.CrosshairType.CSGO, "Crosshair Shape", "The design of the crosshair\n\n\nOptions:\n\n- CSGO\n- Vanilla\n- Accuracy\n- Hollow_Square\n- None", CrosshairRenderer.CrosshairType.class, Settings.EnumDisplayType.DROPDOWN);
        settings.add("centerDot", "CrosshairFX Settings", "Crosshair Shape", true, "Center Dot", "Enables a dot in the center of the crosshair", Settings.BooleanFormat.ONOFF);
        settings.addSlider("dotSize", "CrosshairFX Settings", "Crosshair Shape", 1, "Center Dot Size", "The size of the center dot", 1, 15, 1);
        settings.add("responsiveCrosshair", "CrosshairFX Settings", "Crosshair Color", true, "Responsive Crosshair", "Whether the crosshair color changes based on the targeted block/entity", Settings.BooleanFormat.ONOFF);
        settings.addSlider("linearInterRate", "CrosshairFX Settings", "Accuracy-Based Crosshair", 0.5f, "Linear Interpolation Rate", "The number of pixels for the crosshair to move each frame", 0.01f, 1.0f, 0.01f);
        settings.addSlider("gradientInterRate", "CrosshairFX Settings", "Accuracy-Based Crosshair", 0.03f, "Gradient Interpolation Rate", "The percentage of the distance between the target value and the current value\n\nA value of 1 is the same as no interpolation\nA value of 0.1 means every frame the crosshair will move 10% of the way between its current position and the target position", 0.001f, 1.0f, 0.001f);
        settings.add("accuracyInterMethod", "CrosshairFX Settings", "Accuracy-Based Crosshair", (Enum)CrosshairRenderer.InterpolationMethod.GRADIENT, "Interpolation Method", "The method used to interpolate between positions\n\nOptions:\nGradient\nLinear", CrosshairRenderer.InterpolationMethod.class, Settings.EnumDisplayType.CYCLE);
        settings.addSlider("crosshairSpacing", "CrosshairFX Settings", "Crosshair Shape", 4, "Crosshair Spacing", "The spacing between each line in the crosshair", 1, 100, 1);
        settings.addColor("mainCrosshairCol", "CrosshairFX Settings", "Crosshair Color", -1, "Default Color", "The color of the crosshair when not looking at anything");
        settings.addColor("blockCrosshairCol", "CrosshairFX Settings", "Crosshair Color", -16776961, "Block Color", "The color of the crosshair when looking at a block");
        settings.addColor("enemyCrosshairCol", "CrosshairFX Settings", "Crosshair Color", -65536, "Hostile Mob Color", "The color of the crosshair when looking at a hostile mob");
        settings.addColor("neutralCrosshairCol", "CrosshairFX Settings", "Crosshair Color", -16711936, "Passive Mob Color", "The color of the crosshair when looking at a passive mob");
        settings.orderGroups("CrosshairFX Settings", new String[]{"Crosshair Shape", "Crosshair Color", "Accuracy-Based Crosshair"});
    }
}

