package com.github.wyzzard225.crosshairfx.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class ConfigManager {
	 private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
	 private static final File CONFIG_FILE =
					 new File("config/crosshairfx.json");

	 public static boolean load() {
			if (CONFIG_FILE.exists()) {
				 try (FileReader reader = new FileReader(CONFIG_FILE)) {
						Settings.INSTANCE =
										GSON.fromJson(reader, Settings.class);
				 } catch (IOException e) {
						e.printStackTrace();
				 }
				 return true;
			}
			return false;
	 }

	 public static void save() {
			CrosshairfxClient.console.info("[Mod Template] Saved Config!");
			try (FileWriter writer = new FileWriter(CONFIG_FILE)) {
				 GSON.toJson(Settings.INSTANCE, writer);
			} catch (IOException e) {
				 e.printStackTrace();
			}
	 }
}
