package com.github.wyzzard225.crosshairfx.client;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

import static com.github.wyzzard225.crosshairfx.client.CrosshairRenderer.InterpolationMethod.GRADIENT;
import static com.github.wyzzard225.crosshairfx.client.CrosshairRenderer.InterpolationMethod.LINEAR;
import static com.github.wyzzard225.crosshairfx.client.Settings.CrosshairType.*;

public class CustomConfigScreen {
	 public static class_437 create(class_437 parent) {
			ConfigBuilder builder = ConfigBuilder.create()
							.setParentScreen(parent)
							.setTitle(class_2561.method_43470("CrosshairFX Settings"))
							.setSavingRunnable(ConfigManager::save);

			ConfigEntryBuilder entryBuilder = builder.entryBuilder();
			ConfigCategory visualSettings = builder.getOrCreateCategory(class_2561.method_43470("Cursor Settings"));

			//categories

			SubCategoryBuilder colorSettings = entryBuilder.startSubCategory(class_2561.method_43470("Color Settings"))
							.setExpanded(true);

			SubCategoryBuilder shapeSettings = entryBuilder.startSubCategory(class_2561.method_43470("Shape Settings"))
							.setExpanded(true); // collapsed by default

			SubCategoryBuilder accuracySettings = entryBuilder.startSubCategory(class_2561.method_43470("Accuracy Crosshair Settings"))
							.setExpanded(false)
											.setTooltip(class_2561.method_43470("Settings for the accuracy crosshair\nMust be enabled under Shape Settings"));

//			SubCategoryBuilder chromaSettings = entryBuilder.startSubCategory(Text.literal("Chroma Settings"))
//							.setExpanded(false);

			colorSettings.add(entryBuilder.startBooleanToggle(class_2561.method_43470("Chroma Crosshair"), Settings.INSTANCE.crosshairChroma)
							.setDefaultValue(Settings.defaultSettings.crosshairChroma)
							.setSaveConsumer(newValue -> Settings.INSTANCE.crosshairChroma = newValue)
							.build());

			colorSettings.add(entryBuilder.startBooleanToggle(class_2561.method_43470("Responsive Crosshair"), Settings.INSTANCE.responsiveCrosshair)
							.setDefaultValue(Settings.defaultSettings.responsiveCrosshair)
							.setTooltip(class_2561.method_43470("Whether the crosshair color changes based on the targeted block/entity"))
							.setSaveConsumer(newValue -> Settings.INSTANCE.responsiveCrosshair = newValue)
							.build());

			colorSettings.add(entryBuilder.startAlphaColorField(class_2561.method_43470("Default Color"), Settings.INSTANCE.mainCrosshairCol)
							.setSaveConsumer(newValue -> Settings.INSTANCE.mainCrosshairCol = newValue)
							.setTooltip(class_2561.method_43470("The color of the crosshair when not looking at anything"))
							.setDefaultValue(Settings.defaultSettings.mainCrosshairCol)
							.build());

			colorSettings.add(entryBuilder.startAlphaColorField(class_2561.method_43470("Block Color"), Settings.INSTANCE.blockCrosshairCol)
							.setSaveConsumer(newValue -> Settings.INSTANCE.blockCrosshairCol = newValue)
							.setTooltip(class_2561.method_43470("The color of the crosshair when looking at a block"))
							.setDefaultValue(Settings.defaultSettings.blockCrosshairCol)
							.build());

			colorSettings.add(entryBuilder.startAlphaColorField(class_2561.method_43470("Hostile Mob Color"), Settings.INSTANCE.enemyCrosshairCol)
							.setSaveConsumer(newValue -> Settings.INSTANCE.enemyCrosshairCol = newValue)
							.setTooltip(class_2561.method_43470("The color of the crosshair when looking at a block"))
							.setDefaultValue(Settings.defaultSettings.enemyCrosshairCol)
							.build());

			colorSettings.add(entryBuilder.startAlphaColorField(class_2561.method_43470("Passive Mob Color"), Settings.INSTANCE.neutralCrosshairCol)
							.setSaveConsumer(newValue -> Settings.INSTANCE.neutralCrosshairCol = newValue)
							.setTooltip(class_2561.method_43470("The color of the crosshair when looking at a block"))
							.setDefaultValue(Settings.defaultSettings.neutralCrosshairCol)
							.build());


			shapeSettings.add(entryBuilder.startEnumSelector(class_2561.method_43470("Crosshair Shape"), Settings.CrosshairType.class, Settings.INSTANCE.crosshairShape)
							.setSaveConsumer(newValue -> Settings.INSTANCE.crosshairShape = newValue)
							.setDefaultValue(Settings.defaultSettings.crosshairShape)
											.setEnumNameProvider(value -> switch (value) {
												 case VANILLA -> class_2561.method_43470("Vanilla");
												 case ACCURACY -> class_2561.method_43470("Accuracy-Based");
												 case Settings.CrosshairType.NONE -> class_2561.method_43470("None");
												 case HOLLOW_SQUARE -> class_2561.method_43470("Square");
												 case CSGO -> class_2561.method_43470("CS:GO");
												 default -> class_2561.method_43470("Unknown Value");
											})
							.build());

			shapeSettings.add(entryBuilder.startBooleanToggle(class_2561.method_43470("Center Dot"), Settings.INSTANCE.centerDot)
							.setDefaultValue(Settings.defaultSettings.centerDot)
							.setSaveConsumer(newValue -> Settings.INSTANCE.centerDot = newValue)
							.build());

			shapeSettings.add(entryBuilder.startIntSlider(class_2561.method_43470("Dot Size"),Settings.INSTANCE.dotSize, 1,15)
							.setDefaultValue(Settings.defaultSettings.dotSize)
							.setMin(1)
							.setMax(15)
							.setSaveConsumer(newValue -> Settings.INSTANCE.dotSize = newValue)
							.setTooltip(class_2561.method_43470("The size of the center dot"))
							.build());

			shapeSettings.add(entryBuilder.startIntSlider(class_2561.method_43470("Crosshair Thickness"),Settings.INSTANCE.crosshairThickness, 1,20)
											.setDefaultValue(Settings.defaultSettings.crosshairThickness)
											.setMin(1)
											.setMax(20)
											.setSaveConsumer(newValue -> Settings.INSTANCE.crosshairThickness = newValue)
											.setTooltip(class_2561.method_43470("The thickness of each line in the crosshair"))
							.build());

			shapeSettings.add(entryBuilder.startIntSlider(class_2561.method_43470("Crosshair Length"),Settings.INSTANCE.crosshairLength, 1,100)
							.setDefaultValue(Settings.defaultSettings.crosshairLength)
							.setMin(1)
							.setMax(100)
							.setSaveConsumer(newValue -> Settings.INSTANCE.crosshairLength = newValue)
							.setTooltip(class_2561.method_43470("The length of each line in the crosshair"))
							.build());

			shapeSettings.add(entryBuilder.startIntSlider(class_2561.method_43470("Crosshair Spacing"),Settings.INSTANCE.crosshairSpacing, 1,100)
							.setDefaultValue(Settings.defaultSettings.crosshairSpacing)
							.setMin(1)
							.setMax(100)
							.setSaveConsumer(newValue -> Settings.INSTANCE.crosshairSpacing = newValue)
							.setTooltip(class_2561.method_43470("The spacing of elements in the crosshair\nApplies to 'CS:GO' and 'Accuracy-Based'"))
							.build());


			colorSettings.add(entryBuilder.startFloatField(class_2561.method_43470("Chroma Speed (0.1-20)"), Settings.INSTANCE.chromaDuration)
							.setSaveConsumer(newValue -> Settings.INSTANCE.chromaDuration = newValue)
							.setTooltip(class_2561.method_43470("The number of seconds for each loop of the chroma effect"))
							.setMin(0.1f)
							.setMax(20f)
							.setDefaultValue(Settings.defaultSettings.chromaDuration)
							.build());

			accuracySettings.add(entryBuilder.startEnumSelector(class_2561.method_43470("Interpolation Method"), CrosshairRenderer.InterpolationMethod.class, Settings.INSTANCE.accuracyInterMethod)
							.setSaveConsumer(newValue -> Settings.INSTANCE.accuracyInterMethod = newValue)
							.setDefaultValue(Settings.defaultSettings.accuracyInterMethod)
							.setEnumNameProvider(value -> switch (value) {
								 case CrosshairRenderer.InterpolationMethod.NONE -> class_2561.method_43470("None");
								 case LINEAR -> class_2561.method_43470("Linear");
								 case GRADIENT -> class_2561.method_43470("Ease");
								 default -> class_2561.method_43470("Unknown Value");
							})
											.setTooltip(class_2561.method_43470("How the outside of the crosshair moves between positions\n\nNone: Spacing of the crosshair directly correlates with velocity\nLinear: Crosshair spacing changes at a constant rate based on the current velocity\nEase: Spacing smoothly eases towards the value predicted by the velocity"))
							.build());

			accuracySettings.add(entryBuilder.startDoubleField(class_2561.method_43470("Linear Interpolation Rate (0.01-1)"), Settings.INSTANCE.linearInterRate)
							.setSaveConsumer(newValue -> Settings.INSTANCE.linearInterRate = newValue)
							.setTooltip(class_2561.method_43470("The number number of pixels for the crosshair to move each frame"))
							.setMin(0.01f)
							.setMax(1f)
							.setDefaultValue(Settings.defaultSettings.linearInterRate)
							.build());

			accuracySettings.add(entryBuilder.startDoubleField(class_2561.method_43470("Gradient Interpolation Rate (0.001-1)"), Settings.INSTANCE.gradientInterRate)
							.setSaveConsumer(newValue -> Settings.INSTANCE.gradientInterRate = newValue)
							.setTooltip(class_2561.method_43470("The percentage of the distance between the target value and the current value\n\nA value of 1 is the same as no interpolation\nA value of 0.1 means every frame the crosshair will move 10% of the way between its current position and the target position"))
							.setMin(0.001f)
							.setMax(1f)
							.setDefaultValue(Settings.defaultSettings.gradientInterRate)
							.build());


			visualSettings.addEntry(colorSettings.build());
			visualSettings.addEntry(shapeSettings.build());
			visualSettings.addEntry(accuracySettings.build());
//			visualSettings.addEntry(chromaSettings.build());
//			ConfigCategory general = builder.getOrCreateCategory(Text.literal("General"));
			return builder.build();
	 }
}
