package com.github.wyzzard225.crosshairfx.client;

public class Settings {
	 public enum CrosshairType {
			VANILLA, ACCURACY, NONE, HOLLOW_SQUARE, CSGO
	 }

	 public float chromaDuration;
	 public boolean crosshairChroma;
	 public int crosshairLength;
	 public int crosshairThickness;
	 public CrosshairType crosshairShape;
	 public boolean centerDot;
	 public int dotSize;
	 public int crosshairSpacing;
	 public CrosshairRenderer.InterpolationMethod accuracyInterMethod;
	 public double linearInterRate;
	 public double gradientInterRate;
	 public boolean responsiveCrosshair;

	 public int mainCrosshairCol;
	 public int blockCrosshairCol;
	 public int enemyCrosshairCol;
	 public int neutralCrosshairCol;


	 public static Settings INSTANCE = new Settings();
	 public static Settings defaultSettings = new Settings().resetSettings();

	 public Settings() {}

	 public Settings resetSettings() {
			chromaDuration = 4.0f;
			crosshairChroma = false;
			crosshairLength = 4;
			crosshairThickness = 1;
			crosshairShape = CrosshairType.CSGO;
			mainCrosshairCol = -1;
			blockCrosshairCol = -10197761;
			enemyCrosshairCol = -52686;
			neutralCrosshairCol = -10158236;
			accuracyInterMethod = CrosshairRenderer.InterpolationMethod.GRADIENT;
			crosshairSpacing = 4;
			dotSize = 1;
			centerDot = true;
			linearInterRate = 0.5;
			gradientInterRate = 0.03;
			responsiveCrosshair = true;

			return this;
	 }



}
