package com.github.wyzzard225.crosshairfx.client;


import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_332;

import static com.github.wyzzard225.crosshairfx.client.CrosshairfxClient.settings;

@SuppressWarnings("DataFlowIssue")
public class CrosshairRenderer {
	 @SuppressWarnings("unused")
	 public enum CrosshairType {VANILLA, ACCURACY, NONE, HOLLOW_SQUARE, CSGO}
	 public enum InterpolationMethod{GRADIENT, LINEAR}
	 private static double lastSpacing = 0;

	 public static void drawCenterDot(class_332 context, int color, int size) {
			int x = context.method_51421() / 2;
			int y = context.method_51443() / 2;
			context.method_25294(x-size,y-size,x+size,y+size,color);
	 }

	 public static void drawVanilla(class_332 context, int color, int size, int thickness) {
			int x = context.method_51421() / 2;
			int y = context.method_51443() / 2;

			context.method_25294(x - thickness, y - size, x + thickness, y + size, color); // vertical
			context.method_25294(x - size, y - thickness, x + size, y + thickness, color); // horizontal
	 }

	 public static void drawCSGO(class_332 context, int color, int size, int thickness,int spacing) {
			int x = context.method_51421() / 2;
			int y = context.method_51443() / 2;

			context.method_25294(x - spacing-size, y - thickness, x - spacing, y + thickness, color); // left
			context.method_25294(x + spacing, y - thickness, x + spacing+size, y + thickness, color); // right
			context.method_25294(x - thickness, y - spacing-size, x + thickness, y -spacing, color); // top
			context.method_25294(x-thickness, y + spacing+size, x +thickness, y + spacing, color); // bottom
	 }

	 public static void drawAccuracy(class_332 context, int color, int size, int thickness, int spacing,String interpolMethod ) {
			InterpolationMethod interpolationMethod;
			if (interpolMethod.equalsIgnoreCase("gradient")) {
				 interpolationMethod = InterpolationMethod.GRADIENT;
			} else {
				 interpolationMethod = InterpolationMethod.LINEAR;
			}
			double velocity = Objects.requireNonNull(class_310.method_1551().field_1724).method_18798().method_1033();
			velocity = velocity*50;
			double targetSpacing = spacing*(Math.sqrt(velocity+1));
			if (interpolationMethod==InterpolationMethod.LINEAR) {
				 if (targetSpacing >= lastSpacing) {
						targetSpacing = Math.min(targetSpacing, settings.get("linearInterRate",0.5f) + lastSpacing);
				 } else {
						targetSpacing = Math.max(targetSpacing, lastSpacing - settings.get("linearInterRate",0.5f));
				 }
			}
			if (interpolationMethod==InterpolationMethod.GRADIENT) {
				 targetSpacing = lastSpacing-(settings.get("gradientInterRate",0.5f)*(lastSpacing-targetSpacing));
			}
			lastSpacing = targetSpacing;
			spacing = (int) targetSpacing;

			int x = context.method_51421() / 2;
			int y = context.method_51443() / 2;

			context.method_25294(x - spacing-size, y - thickness, x - spacing, y + thickness, color); // left
			context.method_25294(x + spacing, y - thickness, x + spacing+size, y + thickness, color); // right
			context.method_25294(x - thickness, y - spacing-size, x + thickness, y -spacing, color); // top
			context.method_25294(x-thickness, y + spacing+size, x +thickness, y + spacing, color); // bottom
	 }

	 public static void drawHollowSquare(class_332 context, int color, int size, int thickness) {
			size+=2;
			int x = context.method_51421() / 2;
			int y = context.method_51443() / 2;


			context.method_25294(x-size-thickness,y+size-thickness,x+size+thickness,y+size+thickness,color); //horizontal
			context.method_25294(x-size-thickness,y-size-thickness,x+size+thickness,y-size+thickness,color); //horizontal

			context.method_25294(x-size-thickness,y-size-thickness,x-size+thickness,y+size+thickness,color); //left
			context.method_25294(x+size-thickness,y-size-thickness,x+size+thickness,y+size+thickness,color); //right
	 }

}
