package com.github.wyzzard225.crosshairfx.mixin.features;

import com.github.wyzzard225.crosshairfx.client.CrosshairRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import net.minecraft.class_8012;
import net.minecraft.class_9779;

import static com.github.wyzzard225.crosshairfx.client.CrosshairfxClient.console;
import static com.github.wyzzard225.crosshairfx.client.CrosshairfxClient.settings;

@SuppressWarnings("DataFlowIssue")
@Mixin(class_329.class)
public abstract class CrosshairMixin {
	 @Inject(method = "renderCrosshair", at = @At("HEAD"), cancellable = true)
	 private void onRenderCrosshair(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
			ci.cancel(); //Cancel vanilla crosshair

			int size = settings.get("crosshairLength",1);
			int thickness = settings.get("crosshairThickness",1);
			int color = settings.get("mainCrosshairCol", class_8012.field_42973);

			if (settings.get("crosshairChroma",false)) {
				 color = settings.getChroma();
			} else if(settings.get("responsiveCrosshair",false)) {

				 class_746 player = class_310.method_1551().field_1724;
				 double reach = Objects.requireNonNull(class_310.method_1551().field_1761).method_2920().method_8386() ? 5.0D : 4.5D;
				 class_239 blockHit = Objects.requireNonNull(player).method_5745(reach,1.0f,false);
				 class_243 start = player.method_5836(1.0F);
				 class_243 end = start.method_1019(player.method_5828(1.0F).method_1021(reach));
				 class_238 box = player.method_5829().method_18804(player.method_5828(1.0F).method_1021(reach)).method_1014(1.0D);

				 class_3966 entityHit = class_1675.method_18075(
								 player,
								 start,
								 end,
								 box,
								 e -> !e.method_7325() && e.method_5805(),
								 reach * reach
				 );
				 class_239 finalHit = entityHit != null ? entityHit : blockHit;

				 switch (finalHit.method_17783()) {
						case field_1332 -> color = settings.get("blockCrosshairCol", class_8012.field_54557);
						case field_1331 -> {
							 class_3966 ehr = (class_3966) finalHit;
							 class_1297 e = ehr.method_17782();
							 if (e instanceof class_1309 living) {
									if (living instanceof class_1569) {
										 color = settings.get("enemyCrosshairCol", class_8012.field_41758);
									} else {
										 color = settings.get("neutralCrosshairCol", class_8012.field_52312);
									}
							 }
						}
						case field_1333 -> color = settings.get("mainCrosshairCol", class_8012.field_42973);
				 }
			}

			if (settings.get("centerDot",false)) {
				 CrosshairRenderer.drawCenterDot(context,color,settings.get("dotSize",1));
			}
			int spacing = settings.get("crosshairSpacing",4);
			switch (settings.get("crosshairShape", "CSGO").toLowerCase()) {
				 case "none": return;
				 case "vanilla": CrosshairRenderer.drawVanilla(context,color,size,thickness); break;
				 case "csgo": CrosshairRenderer.drawCSGO(context,color,size,thickness, spacing); break;
				 case "accuracy": CrosshairRenderer.drawAccuracy(context,color,size,thickness, spacing, settings.get("accuracyInterMethod", "")); break;
				 case "hollow_square": CrosshairRenderer.drawHollowSquare(context,color,size,thickness); break;
				 default: console.error("[CrosshairFX] Invalid crosshair shape");
			}
	 }

}
