/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import de.eztxm.luckprefix.common.config.AbstractConfig;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class ConfigService {
    private final Map<Class<? extends AbstractConfig>, AbstractConfig> instanceMap = new ConcurrentHashMap<Class<? extends AbstractConfig>, AbstractConfig>();
    private final Map<Class<? extends AbstractConfig>, ConfigFactory<?>> factoryMap = new ConcurrentHashMap();
    private final Map<Class<? extends AbstractConfig>, Path> pathMap = new ConcurrentHashMap<Class<? extends AbstractConfig>, Path>();

    public <T extends AbstractConfig> void register(Class<T> configClass, Path filePath, ConfigFactory<T> factory) {
        Objects.requireNonNull(configClass, "configClass");
        Objects.requireNonNull(filePath, "filePath");
        Objects.requireNonNull(factory, "factory");
        this.pathMap.put(configClass, filePath);
        this.factoryMap.put(configClass, factory);
    }

    public <T extends AbstractConfig> T of(Class<T> configClass) {
        AbstractConfig existing = this.instanceMap.get(configClass);
        if (existing != null) {
            return (T)existing;
        }
        ConfigFactory<?> factory = this.factoryMap.get(configClass);
        Path filePath = this.pathMap.get(configClass);
        if (factory == null || filePath == null) {
            throw new IllegalStateException("No factory/path registered for " + configClass.getSimpleName());
        }
        Object created = factory.create(filePath);
        ((AbstractConfig)created).load();
        this.instanceMap.put((Class<? extends AbstractConfig>)configClass, (AbstractConfig)created);
        return (T)created;
    }

    public <T extends AbstractConfig> T instance(Class<T> configClass) {
        return this.of(configClass);
    }

    public <T extends AbstractConfig> void reload(Class<T> configClass) {
        T config = this.of(configClass);
        ((AbstractConfig)config).reload();
    }

    public void reloadAll() {
        for (AbstractConfig config : this.instanceMap.values()) {
            config.reload();
        }
    }

    public static interface ConfigFactory<T extends AbstractConfig> {
        public T create(Path var1);
    }
}

