/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateChecker {
    private final String currentVersion;
    private String cachedLatestVersion = "N/A";

    public UpdateChecker(String version) {
        this.currentVersion = version;
        this.cachedLatestVersion = this.getLatestVersion();
    }

    public boolean latestVersion(boolean development) {
        String latestVersion = this.getLatestVersion();
        if (this.isForceUpdate() && !this.currentVersion.equals(latestVersion)) {
            return false;
        }
        if (development) {
            return true;
        }
        if (latestVersion == null) {
            return true;
        }
        if (this.cachedLatestVersion.equalsIgnoreCase("N/A")) {
            return true;
        }
        return latestVersion.equalsIgnoreCase(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLatestVersion() {
        String urlString = "https://cdn.eztxm.de/plugin/luckprefix/manifest.json";
        HttpURLConnection connection = null;
        try {
            URL url = URI.create(urlString).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                String string = this.cachedLatestVersion;
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                if (response.isEmpty()) {
                    String string = this.cachedLatestVersion;
                    return string;
                }
                JSONObject jsonObject = new JSONObject(response.toString());
                this.cachedLatestVersion = jsonObject.getString("Latest-Version");
            }
        }
        catch (IOException e) {
            String string = this.cachedLatestVersion;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return this.cachedLatestVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isForceUpdate() {
        String urlString = "https://cdn.eztxm.de/plugin/luckprefix/manifest.json";
        HttpURLConnection connection = null;
        try {
            URL url = URI.create(urlString).toURL();
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                boolean bl = false;
                return bl;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                if (response.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                JSONObject jsonObject = new JSONObject(response.toString());
                boolean forceUpdate = jsonObject.getBoolean("Force-Update");
                if (!forceUpdate) {
                    boolean bl = false;
                    return bl;
                }
                JSONArray jsonArray = jsonObject.getJSONArray("Force-Update-Versions");
                if (jsonArray.toList().contains(this.cachedLatestVersion)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    @Generated
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    @Generated
    public String getCachedLatestVersion() {
        return this.cachedLatestVersion;
    }
}

