/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import de.eztxm.luckprefix.common.logging.DebugLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public abstract class AbstractConfig {
    private final Path filePath;
    private final DebugLog debugLog;
    private Map<String, Object> dataTree = new LinkedHashMap<String, Object>();
    private List<String> headerComments = new ArrayList<String>();
    private final Map<String, List<String>> perKeyComments = new LinkedHashMap<String, List<String>>();
    private boolean defaultsWereApplied = false;

    protected AbstractConfig(Path filePath, DebugLog debugLog) {
        this.filePath = Objects.requireNonNull(filePath, "filePath");
        this.debugLog = Objects.requireNonNull(debugLog, "debugLog");
        this.debugLog.info(this.getClass().getSimpleName() + ": constructed for " + String.valueOf(filePath));
    }

    protected abstract void defineDefaults();

    protected void afterLoad() {
    }

    public final Path path() {
        return this.filePath;
    }

    public final DebugLog getDebugLog() {
        return this.debugLog;
    }

    public synchronized void load() {
        this.debugLog.info(this.getClass().getSimpleName() + ".load: begin - " + String.valueOf(this.filePath));
        this.ensureParentDirectoryExists();
        this.dataTree = AbstractConfig.loadYamlToMap(this.filePath.toFile(), this.debugLog);
        if (!this.defaultsWereApplied) {
            this.debugLog.debug(this.getClass().getSimpleName() + ".load: applying defaults (first run)");
            this.defineDefaults();
            this.defaultsWereApplied = true;
        }
        try {
            this.afterLoad();
            this.debugLog.debug(this.getClass().getSimpleName() + ".load: afterLoad hook done");
        }
        catch (Exception ex) {
            this.debugLog.error(this.getClass().getSimpleName() + ".load: afterLoad threw", ex);
        }
        this.debugLog.info(this.getClass().getSimpleName() + ".load: done");
    }

    public synchronized void reload() {
        this.debugLog.info(this.getClass().getSimpleName() + ".reload");
        this.load();
    }

    public synchronized void save() {
        this.debugLog.info(this.getClass().getSimpleName() + ".save: writing " + String.valueOf(this.filePath));
        this.ensureParentDirectoryExists();
        AbstractConfig.writeYamlWithComments(this.filePath.toFile(), this.dataTree, this.headerComments, this.perKeyComments, this.debugLog);
        this.debugLog.info(this.getClass().getSimpleName() + ".save: done");
    }

    public synchronized void saveDefaults() {
        this.debugLog.debug(this.getClass().getSimpleName() + ".saveDefaults");
        this.save();
    }

    public synchronized void saveComments() {
        this.debugLog.debug(this.getClass().getSimpleName() + ".saveComments");
        this.save();
    }

    public synchronized long lastModifiedMillis() {
        File target = this.filePath.toFile();
        if (!target.exists()) {
            return 0L;
        }
        return target.lastModified();
    }

    private void ensureParentDirectoryExists() {
        File parent = this.filePath.toFile().getParentFile();
        if (parent == null) {
            return;
        }
        if (parent.exists()) {
            return;
        }
        boolean ok = parent.mkdirs();
        if (ok) {
            this.debugLog.debug(this.getClass().getSimpleName() + ": created directory " + String.valueOf(parent));
        }
        if (!ok) {
            this.debugLog.warn(this.getClass().getSimpleName() + ": failed to create directory " + String.valueOf(parent));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> loadYamlToMap(File sourceFile, DebugLog debugLog) {
        if (!sourceFile.exists()) {
            debugLog.debug("AbstractConfig.loadYamlToMap: file missing, returning empty map: " + String.valueOf(sourceFile));
            return new LinkedHashMap<String, Object>();
        }
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setProcessComments(false);
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(sourceFile), StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(loaderOptions));
            Object root = yaml.load((Reader)reader);
            if (root instanceof Map) {
                Map<String, Object> map = AbstractConfig.deepCopyMap((Map)root);
                debugLog.debug("AbstractConfig.loadYamlToMap: loaded map with " + map.size() + " top-level keys from " + sourceFile.getName());
                Map<String, Object> map2 = map;
                return map2;
            }
            debugLog.warn("AbstractConfig.loadYamlToMap: root is not a map for " + sourceFile.getName() + " \u2192 using empty map");
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            return linkedHashMap;
        }
        catch (IOException io) {
            debugLog.error("AbstractConfig.loadYamlToMap: IO failure for " + sourceFile.getName(), io);
            return new LinkedHashMap<String, Object>();
        }
        catch (Exception ex) {
            debugLog.error("AbstractConfig.loadYamlToMap: parse failure for " + sourceFile.getName(), ex);
            return new LinkedHashMap<String, Object>();
        }
    }

    private static Map<String, Object> deepCopyMap(Map<?, ?> source) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey() == null ? "null" : String.valueOf(entry.getKey());
            Object out = value = entry.getValue();
            if (value instanceof Map) {
                out = AbstractConfig.deepCopyMap((Map)value);
            }
            if (value instanceof List) {
                out = AbstractConfig.deepCopyList((List)value);
            }
            copy.put(key, out);
        }
        return copy;
    }

    private static List<Object> deepCopyList(List<?> source) {
        ArrayList<Object> copy = new ArrayList<Object>(source.size());
        Iterator<?> iterator = source.iterator();
        while (iterator.hasNext()) {
            Object v;
            Object out = v = iterator.next();
            if (v instanceof Map) {
                out = AbstractConfig.deepCopyMap((Map)v);
            }
            if (v instanceof List) {
                out = AbstractConfig.deepCopyList((List)v);
            }
            copy.add(out);
        }
        return copy;
    }

    public synchronized void addDefault(String dottedPath, Object defaultValue) {
        boolean present = this.isSet(dottedPath);
        if (present) {
            return;
        }
        this.debugLog.info(this.getClass().getSimpleName() + ".addDefault: " + dottedPath + " = " + String.valueOf(defaultValue));
        this.set(dottedPath, defaultValue);
    }

    public synchronized void setComments(String dottedPath, List<String> commentLines) {
        ArrayList<String> lines = new ArrayList<String>();
        if (commentLines != null) {
            lines.addAll(commentLines);
        }
        this.perKeyComments.put(dottedPath, lines);
        this.debugLog.debug(this.getClass().getSimpleName() + ".setComments: " + dottedPath + " (" + lines.size() + " lines)");
    }

    public synchronized void setHeaderComments(List<String> lines) {
        this.headerComments = new ArrayList<String>();
        if (lines != null) {
            this.headerComments.addAll(lines);
        }
        this.debugLog.debug(this.getClass().getSimpleName() + ".setHeaderComments: " + this.headerComments.size() + " lines");
    }

    public synchronized boolean contains(String dottedPath) {
        boolean present = this.isSet(dottedPath);
        this.debugLog.debug(this.getClass().getSimpleName() + ".contains: " + dottedPath + " -> " + present);
        return present;
    }

    public synchronized boolean isSet(String dottedPath) {
        Object v = this.get(dottedPath);
        return v != null;
    }

    public synchronized Object get(String dottedPath) {
        String[] parts = dottedPath.split("\\.");
        Map node = this.dataTree;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            boolean last = i == parts.length - 1;
            Object next = node.get(part);
            if (last) {
                return next;
            }
            if (!(next instanceof Map)) {
                return null;
            }
            node = (Map)next;
        }
        return null;
    }

    public synchronized String getString(String dottedPath, String defaultValue) {
        Object raw = this.get(dottedPath);
        if (raw == null) {
            this.debugLog.debug(this.getClass().getSimpleName() + ".getString: " + dottedPath + " -> <default> '" + defaultValue + "'");
            return defaultValue;
        }
        String out = String.valueOf(raw);
        this.debugLog.debug(this.getClass().getSimpleName() + ".getString: " + dottedPath + " -> '" + out + "'");
        return out;
    }

    public synchronized int getInt(String dottedPath, int defaultValue) {
        Object raw = this.get(dottedPath);
        if (raw instanceof Number) {
            int out = ((Number)raw).intValue();
            this.debugLog.debug(this.getClass().getSimpleName() + ".getInt: " + dottedPath + " -> " + out);
            return out;
        }
        if (raw instanceof String) {
            try {
                int parsed = Integer.parseInt((String)raw);
                this.debugLog.debug(this.getClass().getSimpleName() + ".getInt: " + dottedPath + " -> " + parsed + " (parsed)");
                return parsed;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.debugLog.debug(this.getClass().getSimpleName() + ".getInt: " + dottedPath + " -> <default> " + defaultValue);
        return defaultValue;
    }

    public synchronized boolean getBoolean(String dottedPath, boolean defaultValue) {
        Object raw = this.get(dottedPath);
        if (raw instanceof Boolean) {
            boolean out = (Boolean)raw;
            this.debugLog.debug(this.getClass().getSimpleName() + ".getBoolean: " + dottedPath + " -> " + out);
            return out;
        }
        if (raw instanceof String) {
            boolean out = Boolean.parseBoolean((String)raw);
            this.debugLog.debug(this.getClass().getSimpleName() + ".getBoolean: " + dottedPath + " -> " + out + " (parsed)");
            return out;
        }
        this.debugLog.debug(this.getClass().getSimpleName() + ".getBoolean: " + dottedPath + " -> <default> " + defaultValue);
        return defaultValue;
    }

    public synchronized void set(String dottedPath, Object value) {
        String[] parts = dottedPath.split("\\.");
        LinkedHashMap<String, Object> node = this.dataTree;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            Object next = node.get(part);
            boolean isMap = next instanceof Map;
            if (!isMap) {
                LinkedHashMap<String, Object> child = new LinkedHashMap<String, Object>();
                node.put(part, child);
                node = child;
                continue;
            }
            node = (LinkedHashMap<String, Object>)next;
        }
        node.put(parts[parts.length - 1], value);
        this.debugLog.info(this.getClass().getSimpleName() + ".set: " + dottedPath + " = " + String.valueOf(value));
    }

    private static void writeYamlWithComments(File targetFile, Map<String, Object> root, List<String> header, Map<String, List<String>> comments, DebugLog debugLog) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), StandardCharsets.UTF_8));){
            if (header != null && !header.isEmpty()) {
                for (String line : header) {
                    writer.write("# " + line);
                    writer.newLine();
                }
                writer.newLine();
            }
            AbstractConfig.writeSection(writer, root, comments, "", "");
            debugLog.debug("AbstractConfig.writeYamlWithComments: wrote " + targetFile.getName());
        }
        catch (IOException ex) {
            debugLog.error("AbstractConfig.writeYamlWithComments: IO failure for " + targetFile.getName(), ex);
        }
    }

    private static void writeSection(BufferedWriter writer, Map<String, Object> section, Map<String, List<String>> comments, String parentPath, String indent) throws IOException {
        if (section == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : section.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object fullPath = parentPath.isEmpty() ? key : parentPath + "." + key;
            List<String> lines = comments.get(fullPath);
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    writer.write(indent);
                    writer.write("# ");
                    writer.write(line);
                    writer.newLine();
                }
            }
            if (value instanceof Map) {
                writer.write(indent + key + ":");
                writer.newLine();
                AbstractConfig.writeSection(writer, (Map)value, comments, (String)fullPath, indent + "  ");
                continue;
            }
            if (value instanceof List) {
                writer.write(indent + key + ":");
                writer.newLine();
                for (String item : (List)value) {
                    writer.write(indent + "  - " + AbstractConfig.renderScalar(item));
                    writer.newLine();
                }
                continue;
            }
            writer.write(indent + key + ": " + AbstractConfig.renderScalar(value));
            writer.newLine();
        }
    }

    private static String renderScalar(Object value) {
        boolean needsQuotes;
        boolean alreadyQuoted;
        if (value == null) {
            return "null";
        }
        if (value instanceof Boolean || value instanceof Number) {
            return String.valueOf(value);
        }
        String raw = String.valueOf(value);
        boolean bl = alreadyQuoted = raw.startsWith("\"") && raw.endsWith("\"") || raw.startsWith("'") && raw.endsWith("'");
        if (alreadyQuoted) {
            return raw;
        }
        boolean bl2 = needsQuotes = raw.isEmpty() || raw.startsWith("#") || raw.matches(".*[:\\-?&*!|>'\"%@`\\[\\]{}].*") || raw.matches(".*\\s.*");
        if (!needsQuotes) {
            return raw;
        }
        String escaped = raw.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + escaped + "\"";
    }
}

