/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import de.eztxm.luckprefix.common.config.AbstractConfig;
import de.eztxm.luckprefix.common.logging.DebugLog;
import java.nio.file.Path;
import java.util.List;

public final class MainConfig
extends AbstractConfig {
    private final String pluginVersion;

    public MainConfig(Path filePath, DebugLog debugLog, String pluginVersion) {
        super(filePath, debugLog);
        this.pluginVersion = pluginVersion == null ? "unknown" : pluginVersion;
        this.getDebugLog().info("MainConfig: constructed, version=" + this.pluginVersion);
    }

    @Override
    protected void defineDefaults() {
        this.getDebugLog().info("MainConfig.defineDefaults: applying");
        this.setHeaderComments(List.of(" _               _    ____            __ _", "| |   _   _  ___| | _|  _ \\ _ __ ___ / _(_)_  __", "| |  | | | |/ __| |/ / |_) | '__/ _ \\ |_| \\ \\/ /", "| |__| |_| | (__|   <|  __/| | |  __/  _| |>  <", "|_____\\__,_|\\___|_|\\_\\_|   |_|  \\___|_| |_/_/\\_\\", "Modern " + this.pluginVersion + " | by ezTxmMC", "", "This plugin supports MiniMessage and legacy '&' color codes."));
        this.addDefault("Update-Channel", "release");
        this.addDefault("ColoredPermission", "luckprefix.coloredmessages");
        this.addDefault("AutoReloadConfig.Enabled", false);
        this.addDefault("UpdateTime", 5);
        this.addDefault("ShowNameTags", true);
        this.addDefault("UpdateAvailableMessage", true);
        this.addDefault("Warning-If-Group-Can-Not-Loaded", true);
        this.addDefault("Auto-Add-Group", true);
        this.addDefault("Print-Warnings", false);
        this.addDefault("Logging.ConsoleEnabled", true);
        this.addDefault("Logging.Debug.Enabled", true);
        this.addDefault("Logging.Debug.File", "luckprefix-debug.log");
        this.saveDefaults();
        this.getDebugLog().debug("MainConfig.defineDefaults: defaults saved");
        this.setComments("Update-Channel", List.of("The channel which should be used for the update checker", "Choose between \"release\", \"beta\" and \"snapshot\" version", "Default: release", "ONLY CHANGE IF YOU KNOW WHAT YOU ARE DOING!"));
        this.setComments("ColoredPermission", List.of("Permission required to use color codes in chat"));
        this.setComments("AutoReloadConfig", List.of("Automatically reload of the config"));
        this.setComments("AutoReloadConfig.Enabled", List.of("If true it automatically reloads the config after the interval"));
        this.setComments("UpdateTime", List.of("Time in seconds to refresh prefixes"));
        this.setComments("ShowNameTags", List.of("Shows the nametag above the players"));
        this.setComments("UpdateAvailableMessage", List.of("Show message when a new update is available"));
        this.setComments("Warning-If-Group-Can-Not-Loaded", List.of("Warn for each group missing in groups.yml"));
        this.setComments("Auto-Add-Group", List.of("If true it will automatically insert not existing groups into groups.yml or the database", "ONLY DISABLE IF YOU KNOW WHAT YOU ARE DOING!"));
        this.setComments("Logging", List.of("Logging settings"));
        this.setComments("Logging.ConsoleEnabled", List.of("If true, prints warnings/info to console"));
        this.setComments("Logging.Debug.Enabled", List.of("Deprecated toggle; debug file logger is always active"));
        this.setComments("Logging.Debug.File", List.of("Debug log file path"));
        this.saveComments();
        this.getDebugLog().debug("MainConfig.defineDefaults: comments saved");
    }

    public String getUpdateChannel() {
        String value = this.getString("Update-Channel", "release");
        this.getDebugLog().debug("MainConfig.getUpdateChannel -> " + value);
        return value;
    }

    public String getColoredPermission() {
        String value = this.getString("ColoredPermission", "luckprefix.coloredmessages");
        this.getDebugLog().debug("MainConfig.getColoredPermission -> " + value);
        return value;
    }

    public boolean isAutoReloadEnabled() {
        boolean value = this.getBoolean("AutoReloadConfig.Enabled", false);
        this.getDebugLog().debug("MainConfig.isAutoReloadEnabled -> " + value);
        return value;
    }

    public boolean isPrintWarningsEnabled() {
        return this.getBoolean("PrintWarnings", false);
    }

    public int getUpdateTimeSeconds() {
        int value = this.getInt("UpdateTime", 5);
        this.getDebugLog().debug("MainConfig.getUpdateTimeSeconds -> " + value);
        return value;
    }

    public boolean isShowNameTags() {
        boolean value = this.getBoolean("ShowNameTags", true);
        this.getDebugLog().debug("MainConfig.isShowNameTags -> " + value);
        return value;
    }

    public boolean isUpdateAvailableMessageEnabled() {
        boolean value = this.getBoolean("UpdateAvailableMessage", true);
        this.getDebugLog().debug("MainConfig.isUpdateAvailableMessageEnabled -> " + value);
        return value;
    }

    public boolean isWarnIfGroupCannotBeLoaded() {
        boolean value = this.getBoolean("Warning-If-Group-Can-Not-Loaded", true);
        this.getDebugLog().debug("MainConfig.isWarnIfGroupCannotBeLoaded -> " + value);
        return value;
    }

    public boolean isAutoAddGroupEnabled() {
        boolean value = this.getBoolean("Auto-Add-Group", true);
        this.getDebugLog().debug("MainConfig.isAutoAddGroupEnabled -> " + value);
        return value;
    }

    public boolean isConsoleLoggingEnabled() {
        boolean value = this.getBoolean("Logging.ConsoleEnabled", true);
        this.getDebugLog().debug("MainConfig.isConsoleLoggingEnabled -> " + value);
        return value;
    }

    public boolean isDebugLoggingFlagEnabled() {
        boolean value = this.getBoolean("Logging.Debug.Enabled", true);
        this.getDebugLog().debug("MainConfig.isDebugLoggingFlagEnabled -> " + value);
        return value;
    }

    public String getDebugLogFile() {
        String value = this.getString("Logging.Debug.File", "luckprefix-debug.log");
        this.getDebugLog().debug("MainConfig.getDebugLogFile -> " + value);
        return value;
    }
}

