/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlIO {
    private YamlIO() {
    }

    public static Map<String, Object> load(File file) throws IOException {
        if (!file.exists()) {
            return new LinkedHashMap<String, Object>();
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions().setProcessComments(false)));
            Object object = yaml.load((Reader)reader);
            if (object instanceof Map) {
                Map<String, Object> map = YamlIO.deepCopy((Map)object);
                return map;
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadFromString(String yamlText) throws IOException {
        File tmp = File.createTempFile("lp-default", ".yml");
        try {
            YamlIO.save(tmp, null);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), StandardCharsets.UTF_8);){
                writer.write(yamlText == null ? "" : yamlText);
            }
            Map<String, Object> map = YamlIO.load(tmp);
            return map;
        }
        finally {
            tmp.delete();
        }
    }

    public static void save(File file, Map<String, Object> data) throws IOException {
        file.getParentFile().mkdirs();
        DumperOptions opt = new DumperOptions();
        opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        opt.setPrettyFlow(true);
        opt.setIndent(2);
        opt.setIndicatorIndent(2);
        opt.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions().setProcessComments(false)), new Representer(opt), opt);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            yaml.dump(data == null ? new LinkedHashMap() : data, (Writer)writer);
        }
    }

    private static Map<String, Object> deepCopy(Map<?, ?> src) {
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : src.entrySet()) {
            String key = entry.getKey() == null ? "null" : String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Map) {
                out.put(key, YamlIO.deepCopy((Map)value));
                continue;
            }
            out.put(key, value);
        }
        return out;
    }
}

