/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.util;

import de.eztxm.luckprefix.LuckPrefix;
import de.eztxm.luckprefix.common.config.ConfigService;
import de.eztxm.luckprefix.common.config.DatabaseConfig;
import de.eztxm.luckprefix.common.config.GroupsConfig;
import de.eztxm.luckprefix.common.config.MainConfig;
import de.eztxm.luckprefix.common.util.Encoder;
import de.eztxm.luckprefix.util.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.luckperms.api.model.group.Group;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class GroupManager {
    private static final int TEAM_NAME_MAX_LENGTH = 16;
    private final LuckPrefix plugin;
    private final List<String> loadedGroups = Collections.synchronizedList(new ArrayList());
    private final Map<String, String> prefixByGroup = new ConcurrentHashMap<String, String>();
    private final Map<String, String> suffixByGroup = new ConcurrentHashMap<String, String>();
    private final Map<String, String> tabFormatByGroup = new ConcurrentHashMap<String, String>();
    private final Map<String, String> chatFormatByGroup = new ConcurrentHashMap<String, String>();
    private final Map<String, String> sortIdByGroup = new ConcurrentHashMap<String, String>();
    private final Map<String, ChatColor> nameColorByGroup = new ConcurrentHashMap<String, ChatColor>();

    public GroupManager(LuckPrefix plugin) {
        this.plugin = plugin;
    }

    public void loadGroups() {
        ConfigService configService = this.plugin.getConfigService();
        MainConfig mainConfig = configService.of(MainConfig.class);
        GroupsConfig groupsConfig = configService.of(GroupsConfig.class);
        for (Group lpGroup : this.plugin.getLuckPerms().getGroupManager().getLoadedGroups()) {
            String rawGroupName = lpGroup.getName();
            if (groupsConfig.hasGroup(rawGroupName)) {
                this.createGroup(rawGroupName);
                continue;
            }
            if (!mainConfig.isWarnIfGroupCannotBeLoaded()) continue;
            this.plugin.getLogger().warning("Group '" + rawGroupName + "' can't be loaded (not found in groups.yml).");
        }
        long updateIntervalSeconds = Math.max(1L, (long)mainConfig.getUpdateTimeSeconds());
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                return;
            }
            for (Player online : Bukkit.getOnlinePlayers()) {
                this.plugin.getPlayerManager().setPlayerListName(online.getUniqueId(), Objects.requireNonNull(this.plugin.getLuckPerms().getUserManager().getUser(online.getUniqueId())).getPrimaryGroup());
            }
        }, 1L, updateIntervalSeconds * 20L);
    }

    public void reloadAllFromConfigs() {
        this.clearAllCaches();
        for (Group lpGroup : this.plugin.getLuckPerms().getGroupManager().getLoadedGroups()) {
            this.createGroup(lpGroup.getName());
        }
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.plugin.getPlayerManager().setPlayerListName(p.getUniqueId(), Objects.requireNonNull(this.plugin.getLuckPerms().getUserManager().getUser(p.getUniqueId())).getPrimaryGroup());
            }
        }
        this.refreshAllScoreboards();
    }

    public void reloadGroup(String rawGroupName) {
        this.deleteGroup(rawGroupName);
        this.createGroup(rawGroupName);
    }

    public void createGroup(String rawGroupName) {
        ConfigService configService = this.plugin.getConfigService();
        DatabaseConfig databaseConfig = configService.of(DatabaseConfig.class);
        if (databaseConfig.isDatabaseEnabled()) {
            return;
        }
        MainConfig mainConfig = configService.of(MainConfig.class);
        GroupsConfig groupsConfig = configService.of(GroupsConfig.class);
        boolean autoAddGroup = mainConfig.isAutoAddGroupEnabled();
        boolean warnIfMissing = mainConfig.isWarnIfGroupCannotBeLoaded();
        if (rawGroupName.contains(":") && warnIfMissing) {
            this.plugin.getLogger().warning("Group name '" + rawGroupName + "' contains ':' \u2014 will be stored as '" + Encoder.key(rawGroupName) + "' in groups.yml.");
        }
        groupsConfig.ensureGroupDefaults(rawGroupName, autoAddGroup, mainConfig.isPrintWarningsEnabled(), this.plugin.getLogger()::warning);
        String prefix = groupsConfig.getPrefix(rawGroupName);
        String suffix = groupsConfig.getSuffix(rawGroupName);
        String tabFormat = groupsConfig.getTabFormat(rawGroupName);
        String chatFormat = groupsConfig.getChatFormat(rawGroupName);
        int sortId = groupsConfig.getSortId(rawGroupName);
        if (sortId < 0) {
            sortId = 0;
        }
        String paddedSortId = String.format("%04d", sortId);
        ChatColor chatColor = ChatColor.GRAY;
        String colorName = groupsConfig.getNameColor(rawGroupName);
        if (colorName != null) {
            try {
                chatColor = ChatColor.valueOf((String)colorName.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().warning("groups.yml: '" + rawGroupName + ".NameColor' = '" + colorName + "' is invalid \u2014 falling back to GRAY.");
            }
        }
        this.loadedGroups.add(rawGroupName);
        this.prefixByGroup.put(rawGroupName, prefix == null ? "" : prefix);
        this.suffixByGroup.put(rawGroupName, suffix == null ? "" : suffix);
        this.tabFormatByGroup.put(rawGroupName, tabFormat == null ? "" : tabFormat);
        this.chatFormatByGroup.put(rawGroupName, chatFormat == null ? "" : chatFormat);
        this.sortIdByGroup.put(rawGroupName, paddedSortId);
        this.nameColorByGroup.put(rawGroupName, chatColor);
    }

    public void deleteGroup(String rawGroupName) {
        this.loadedGroups.remove(rawGroupName);
        this.prefixByGroup.remove(rawGroupName);
        this.suffixByGroup.remove(rawGroupName);
        this.tabFormatByGroup.remove(rawGroupName);
        this.chatFormatByGroup.remove(rawGroupName);
        this.sortIdByGroup.remove(rawGroupName);
        this.nameColorByGroup.remove(rawGroupName);
    }

    public void setGroups(Player player, Scoreboard scoreboard) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.setGroups(player, scoreboard));
            return;
        }
        this.setupGroups(player);
        for (Player online : Bukkit.getOnlinePlayers()) {
            Team currentTeam;
            String teamKey;
            Team team;
            String currentGroup = this.plugin.getPlayerManager().getUserGroups().get(online.getUniqueId());
            String sortId = this.sortIdByGroup.get(currentGroup);
            if (sortId == null) {
                sortId = this.sortIdByGroup.get("default");
                currentGroup = "default";
            }
            if ((team = scoreboard.getTeam(teamKey = this.buildTeamKey(currentGroup))) == null) {
                this.setupGroups(online);
                team = scoreboard.getTeam(this.buildTeamKey("default"));
            }
            if (team != null && (currentTeam = scoreboard.getEntryTeam(online.getName())) != team) {
                if (currentTeam != null) {
                    try {
                        currentTeam.removeEntry(online.getName());
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                try {
                    team.addEntry(online.getName());
                }
                catch (IllegalStateException ex) {
                    this.plugin.getLogger().warning("Failed to add player to team: " + ex.getMessage());
                }
            }
            this.plugin.getPlayerManager().setPlayerListName(online.getUniqueId(), Objects.requireNonNull(this.plugin.getLuckPerms().getUserManager().getUser(online.getUniqueId())).getPrimaryGroup());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupGroups(Player player) {
        GroupManager groupManager = this;
        synchronized (groupManager) {
            Scoreboard scoreboard = player.getScoreboard();
            for (String rawGroupName : new ArrayList<String>(this.loadedGroups)) {
                ChatColor teamColor;
                String tabFormat;
                String teamName = this.buildTeamKey(rawGroupName);
                Team team = scoreboard.getTeam(teamName);
                if (team == null) {
                    team = scoreboard.registerNewTeam(teamName);
                }
                if ((tabFormat = this.tabFormatByGroup.get(rawGroupName)) != null) {
                    String suffix;
                    String prefix = this.prefixByGroup.get(rawGroupName);
                    if (prefix != null && tabFormat.contains("<prefix>")) {
                        try {
                            String legacyPrefix = new Text(tabFormat.replace("<prefix>", prefix).replace("<suffix>", "").replace("<player>", "")).placeholders(player).legacyMiniMessage(new TagResolver[0]);
                            team.setPrefix(legacyPrefix);
                        }
                        catch (Exception ex) {
                            this.plugin.getLogger().warning("Error setting team prefix for group " + rawGroupName + ": " + ex.getMessage());
                        }
                    }
                    if ((suffix = this.suffixByGroup.get(rawGroupName)) != null && tabFormat.contains("<suffix>")) {
                        try {
                            String legacySuffix = new Text(suffix).placeholders(player).legacyMiniMessage(new TagResolver[0]);
                            team.setSuffix(legacySuffix);
                        }
                        catch (Exception ex) {
                            this.plugin.getLogger().warning("Error setting team suffix for group " + rawGroupName + ": " + ex.getMessage());
                        }
                    }
                }
                if ((teamColor = this.nameColorByGroup.get(rawGroupName)) == null) continue;
                try {
                    team.setColor(teamColor);
                }
                catch (Exception ex) {
                    this.plugin.getLogger().warning("Error setting team color for group " + rawGroupName + ": " + ex.getMessage());
                }
            }
        }
    }

    public void refreshAllScoreboards() {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, this::refreshAllScoreboards);
            return;
        }
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.setupGroups(viewer);
        }
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.setGroups(viewer, viewer.getScoreboard());
        }
    }

    private void clearAllCaches() {
        this.loadedGroups.clear();
        this.prefixByGroup.clear();
        this.suffixByGroup.clear();
        this.tabFormatByGroup.clear();
        this.chatFormatByGroup.clear();
        this.sortIdByGroup.clear();
        this.nameColorByGroup.clear();
    }

    private String buildTeamKey(String rawGroupName) {
        String paddedSortId = this.sortIdByGroup.getOrDefault(rawGroupName, "9999");
        Object key = paddedSortId + Encoder.key(rawGroupName);
        if (((String)(key = ((String)key).replace(' ', '_'))).length() > 16) {
            key = ((String)key).substring(0, 16);
        }
        return key;
    }

    @Generated
    public LuckPrefix getPlugin() {
        return this.plugin;
    }

    @Generated
    public List<String> getLoadedGroups() {
        return this.loadedGroups;
    }

    @Generated
    public Map<String, String> getPrefixByGroup() {
        return this.prefixByGroup;
    }

    @Generated
    public Map<String, String> getSuffixByGroup() {
        return this.suffixByGroup;
    }

    @Generated
    public Map<String, String> getTabFormatByGroup() {
        return this.tabFormatByGroup;
    }

    @Generated
    public Map<String, String> getChatFormatByGroup() {
        return this.chatFormatByGroup;
    }

    @Generated
    public Map<String, String> getSortIdByGroup() {
        return this.sortIdByGroup;
    }

    @Generated
    public Map<String, ChatColor> getNameColorByGroup() {
        return this.nameColorByGroup;
    }
}

