/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.util;

import de.eztxm.luckprefix.LuckPrefix;
import de.eztxm.luckprefix.util.GroupManager;
import de.eztxm.luckprefix.util.Text;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class PlayerManager {
    private final Map<UUID, BukkitTask> joinSchedulers = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, String> userGroups = new HashMap<UUID, String>();

    public void initializePlayer(UUID uuid, String group) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        this.userGroups.put(uuid, group);
    }

    public void setPlayerListName(UUID uuid, String luckPermsGroup) {
        GroupManager groupManager = LuckPrefix.getInstance().getGroupManager();
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        if (!this.userGroups.containsKey(uuid)) {
            return;
        }
        String group = this.userGroups.get(uuid);
        if (group.equalsIgnoreCase(luckPermsGroup)) {
            return;
        }
        group = luckPermsGroup;
        this.userGroups.put(uuid, group);
        if (groupManager.getPrefixByGroup().get(group) == null) {
            if (groupManager.getSuffixByGroup().get(group) == null) {
                return;
            }
            TagResolver.Single suffix = Placeholder.component((String)"suffix", (ComponentLike)new Text(groupManager.getSuffixByGroup().get(group)).placeholders(player).miniMessage());
            player.setPlayerListName(new Text(groupManager.getTabFormatByGroup().get(group)).placeholders(player).legacyMiniMessage(new TagResolver[]{Placeholder.component((String)"prefix", (ComponentLike)Component.text((String)"")), suffix, Placeholder.component((String)"player", (ComponentLike)new Text(player.getName()).placeholders(player).component())}));
            return;
        }
        TagResolver.Single prefix = Placeholder.component((String)"prefix", (ComponentLike)new Text(groupManager.getPrefixByGroup().get(group)).placeholders(player).miniMessage());
        if (groupManager.getSuffixByGroup().get(group) == null) {
            player.setPlayerListName(new Text(groupManager.getTabFormatByGroup().get(group)).placeholders(player).legacyMiniMessage(new TagResolver[]{prefix, Placeholder.component((String)"suffix", (ComponentLike)Component.text((String)"")), Placeholder.component((String)"player", (ComponentLike)new Text(player.getName()).placeholders(player).component())}));
            return;
        }
        TagResolver.Single suffix = Placeholder.component((String)"suffix", (ComponentLike)new Text(groupManager.getSuffixByGroup().get(group)).placeholders(player).miniMessage());
        player.setPlayerListName(new Text(groupManager.getTabFormatByGroup().get(group)).placeholders(player).legacyMiniMessage(new TagResolver[]{prefix, suffix, Placeholder.component((String)"player", (ComponentLike)new Text(player.getName()).placeholders(player).component())}));
    }

    public void addJoinScheduler(UUID uuid, BukkitTask bukkitTask) {
        this.joinSchedulers.put(uuid, bukkitTask);
    }

    public void setUserGroup(UUID uuid, String group) {
        this.userGroups.put(uuid, group);
    }

    public void cancelJoinScheduler(UUID uuid) {
        this.joinSchedulers.get(uuid).cancel();
    }

    public void removeJoinScheduler(UUID uuid) {
        this.joinSchedulers.remove(uuid);
    }

    public void removeUserGroup(UUID uuid) {
        this.userGroups.remove(uuid);
    }

    @Generated
    public Map<UUID, BukkitTask> getJoinSchedulers() {
        return this.joinSchedulers;
    }

    @Generated
    public Map<UUID, String> getUserGroups() {
        return this.userGroups;
    }
}

