/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix;

import de.eztxm.ezlib.api.database.SQLConnection;
import de.eztxm.ezlib.database.MongoDBConnection;
import de.eztxm.luckprefix.Registry;
import de.eztxm.luckprefix.command.LuckPrefixCommand;
import de.eztxm.luckprefix.common.config.ConfigService;
import de.eztxm.luckprefix.common.config.ConfigWatcher;
import de.eztxm.luckprefix.common.config.DatabaseConfig;
import de.eztxm.luckprefix.common.config.GroupsConfig;
import de.eztxm.luckprefix.common.config.MainConfig;
import de.eztxm.luckprefix.common.logging.DebugLog;
import de.eztxm.luckprefix.common.util.UpdateChecker;
import de.eztxm.luckprefix.depend.LuckPrefixPlaceholderExtension;
import de.eztxm.luckprefix.libs.bstats.bukkit.Metrics;
import de.eztxm.luckprefix.libs.bstats.charts.SimplePie;
import de.eztxm.luckprefix.listener.ChatListener;
import de.eztxm.luckprefix.listener.GroupListener;
import de.eztxm.luckprefix.listener.JoinListener;
import de.eztxm.luckprefix.listener.QuitListener;
import de.eztxm.luckprefix.util.DependUtil;
import de.eztxm.luckprefix.util.GroupManager;
import de.eztxm.luckprefix.util.PlayerManager;
import de.eztxm.luckprefix.util.Text;
import java.nio.file.Path;
import lombok.Generated;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class LuckPrefix
extends JavaPlugin {
    private static final boolean development = false;
    private static LuckPrefix instance;
    private static boolean leafCompatibility;
    private DebugLog debugLog;
    private String prefix;
    private DependUtil dependUtil;
    private ConfigService configService;
    private ConfigWatcher configWatcher;
    private MongoDBConnection mongoDBConnection;
    private SQLConnection sqlConnection;
    private BukkitAudiences adventure;
    private LuckPerms luckPerms;
    private Registry registry;
    private PlayerManager playerManager;
    private GroupManager groupManager;
    private GroupListener groupListener;
    private UpdateChecker updateChecker;
    private BukkitTask autoReloadConfigTask;
    private Metrics metrics;

    public void onEnable() {
        this.setupLogger();
        this.checkCompatibility();
        this.saveDefaultConfig();
        instance = this;
        this.prefix = "<gradient:#42EC63:#66EC82>LuckPrefix <dark_gray>| <gray>";
        this.dependUtil = new DependUtil((Plugin)this);
        if (!this.dependUtil.isLuckPermsEnabled()) {
            this.getServer().broadcastMessage(new Text("<#ff2222>LuckPerms can't be found. Disabling LuckPrefix...").legacyMiniMessage(new TagResolver[0]));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupConfigs();
        MainConfig mainConfig = this.configService.of(MainConfig.class);
        this.adventure = BukkitAudiences.create((Plugin)instance);
        this.luckPerms = LuckPermsProvider.get();
        this.registry = new Registry((Plugin)instance);
        this.registry.registerCommand("luckprefix", (CommandExecutor)new LuckPrefixCommand());
        this.registry.registerListener(new JoinListener());
        this.registry.registerListener(new QuitListener());
        this.registry.registerListener(new ChatListener());
        this.playerManager = new PlayerManager();
        this.groupManager = new GroupManager(instance);
        this.groupListener = new GroupListener(this.luckPerms, this.groupManager, this.playerManager);
        this.groupListener.onCreateGroup();
        this.groupListener.onDeleteGroup();
        this.groupListener.onUpdateGroup();
        this.groupListener.onUpdateUserGroup();
        this.groupManager.loadGroups();
        if (this.dependUtil.isPlaceholderAPIEnabled()) {
            new LuckPrefixPlaceholderExtension((Plugin)this).register();
            this.getServer().broadcastMessage(new Text("<#33ffff>PlaceholderAPI <gray>was detected successfully.").legacyMiniMessage(new TagResolver[0]));
        }
        this.updateChecker = new UpdateChecker(mainConfig.getUpdateChannel(), this.getDescription().getVersion(), this.debugLog);
        if (!this.updateChecker.isLatestVersion(false)) {
            this.getLogger().warning("Newer version " + this.updateChecker.getCachedLatestVersion() + " is available at https://modrinth.com/plugin/luckprefix");
        }
        if (LuckPrefix.isLeafCompatibility()) {
            this.getLogger().info("LuckPrefix is running in Leaf Compatibility mode.");
        }
        this.metrics = new Metrics((Plugin)instance, 27277);
        this.metrics.addCustomChart(new SimplePie("used_groups", () -> String.valueOf(this.groupManager.getLoadedGroups().size())));
        this.metrics.addCustomChart(new SimplePie("auto_reload", () -> String.valueOf(mainConfig.isAutoReloadEnabled())));
        this.metrics.addCustomChart(new SimplePie("console_logging", () -> String.valueOf(mainConfig.isConsoleLoggingEnabled())));
        this.metrics.addCustomChart(new SimplePie("print_warnings", () -> String.valueOf(mainConfig.isPrintWarningsEnabled())));
        this.metrics.addCustomChart(new SimplePie("debug_logging_flag", () -> String.valueOf(mainConfig.isDebugLoggingFlagEnabled())));
        this.metrics.addCustomChart(new SimplePie("show_nametags", () -> String.valueOf(mainConfig.isShowNameTags())));
    }

    private void setupConfigs() {
        this.configService = new ConfigService();
        Path dataFolderPath = this.getDataFolder().toPath();
        Path configPath = dataFolderPath.resolve("config.yml");
        Path databasePath = dataFolderPath.resolve("database.yml");
        Path groupsPath = dataFolderPath.resolve("groups.yml");
        String pluginVersion = this.getDescription().getVersion();
        String sqliteDefaultPath = dataFolderPath.resolve("storage").toString().replace("\\", "/");
        this.configService.register(MainConfig.class, configPath, path -> new MainConfig(path, this.debugLog, pluginVersion));
        this.configService.register(DatabaseConfig.class, databasePath, path -> new DatabaseConfig(path, this.debugLog));
        this.configService.register(GroupsConfig.class, groupsPath, path -> new GroupsConfig(path, this.debugLog));
        MainConfig config = this.configService.of(MainConfig.class);
        this.startConfigWatcher(config);
    }

    public void startConfigWatcher(MainConfig config) {
        if (config.isAutoReloadEnabled()) {
            this.configWatcher = new ConfigWatcher(this.getDataFolder(), path -> {
                String fileName;
                switch (fileName = path.getFileName().toString().toLowerCase()) {
                    case "config.yml": {
                        this.configService.reload(MainConfig.class);
                        Bukkit.getScheduler().runTask((Plugin)this, () -> this.groupManager.reloadAllFromConfigs());
                        break;
                    }
                    case "database.yml": {
                        this.configService.reload(DatabaseConfig.class);
                        break;
                    }
                    case "groups.yml": {
                        this.configService.reload(GroupsConfig.class);
                        Bukkit.getScheduler().runTask((Plugin)this, () -> this.groupManager.reloadAllFromConfigs());
                        break;
                    }
                    default: {
                        this.getLogger().warning("Unknown config file: " + fileName);
                        return false;
                    }
                }
                this.getLogger().info("Reloading %s file".formatted(fileName));
                return true;
            });
            this.configWatcher.start();
        }
    }

    private void setupLogger() {
        this.debugLog = new DebugLog(this.getDataFolder().toPath().resolve("debug.log"), 1000000L);
    }

    private void checkCompatibility() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        String brand = (Bukkit.getName() + " " + bukkitVersion).toLowerCase();
        leafCompatibility = brand.contains("leaf");
        this.debugLog.info("LuckPrefix compatibility has been detected in " + brand);
    }

    public void onDisable() {
        instance = null;
        this.registry = null;
        this.playerManager = null;
        this.groupManager = null;
        this.groupListener = null;
        this.updateChecker = null;
        this.configService = null;
        if (this.configWatcher != null) {
            this.configWatcher.stop();
        }
        this.configWatcher = null;
        this.mongoDBConnection = null;
        this.sqlConnection = null;
        this.adventure = null;
        this.luckPerms = null;
        this.autoReloadConfigTask = null;
        this.metrics.shutdown();
        this.metrics = null;
    }

    @Generated
    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public DependUtil getDependUtil() {
        return this.dependUtil;
    }

    @Generated
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Generated
    public ConfigWatcher getConfigWatcher() {
        return this.configWatcher;
    }

    @Generated
    public MongoDBConnection getMongoDBConnection() {
        return this.mongoDBConnection;
    }

    @Generated
    public SQLConnection getSqlConnection() {
        return this.sqlConnection;
    }

    @Generated
    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    @Generated
    public LuckPerms getLuckPerms() {
        return this.luckPerms;
    }

    @Generated
    public Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    @Generated
    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    @Generated
    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public BukkitTask getAutoReloadConfigTask() {
        return this.autoReloadConfigTask;
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public static boolean isDevelopment() {
        return false;
    }

    @Generated
    public static LuckPrefix getInstance() {
        return instance;
    }

    @Generated
    public static boolean isLeafCompatibility() {
        return leafCompatibility;
    }

    static {
        leafCompatibility = false;
    }
}

