/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.command;

import de.eztxm.luckprefix.LuckPrefix;
import de.eztxm.luckprefix.command.subcommand.GroupSubCommand;
import de.eztxm.luckprefix.command.subcommand.ReloadConfigsSubCommand;
import de.eztxm.luckprefix.util.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.luckperms.api.LuckPerms;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckPrefixCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            LuckPrefix.getInstance().getLogger().warning("You must be a player to use this command.");
            return false;
        }
        Player player = (Player)sender;
        Audience adventurePlayer = LuckPrefix.getInstance().getAdventure().player(player);
        if (!player.hasPermission("luckprefix.command")) {
            adventurePlayer.sendMessage(new Text("<#ff3333>You don't have the permission to use this command.").prefixMiniMessage());
            return false;
        }
        if (args.length < 1) {
            adventurePlayer.sendMessage(new Text("<dark_gray><st>------------</st><#77ef77>LuckPrefix<dark_gray><st>------------</st>\n<dark_gray>\u00bb <gray>/luckprefix group <name> prefix - Shows the current prefix\n<dark_gray>\u00bb <gray>/luckprefix group <name> prefix set <string> - Set the current prefix\n<dark_gray>\u00bb <gray>/luckprefix group <name> suffix - Shows the current suffix\n<dark_gray>\u00bb <gray>/luckprefix group <name> suffix set <string> - Set the current suffix\n<dark_gray>\u00bb <gray>/luckprefix group <name> tabformat - Shows the current tabformat\n<dark_gray>\u00bb <gray>/luckprefix group <name> tabformat set <string> - Set the current tabformat\n<dark_gray>\u00bb <gray>/luckprefix group <name> chatformat - Shows the current chatformat\n<dark_gray>\u00bb <gray>/luckprefix group <name> chatformat set <string> - Set the current chatformat\n<dark_gray>\u00bb <gray>/luckprefix group <name> sortid - Shows the current sortid\n<dark_gray>\u00bb <gray>/luckprefix group <name> sortid set <string> - Set the current sortid\n<dark_gray>\u00bb <gray>/luckprefix group <name> namecolor - Shows the current namecolor\n<dark_gray>\u00bb <gray>/luckprefix group <name> namecolor set <string> - Set the current namecolor\n<dark_gray>\u00bb <gray>/luckprefix reload - Reloads all configurations\n<dark_gray><st>------------</st><#77ef77>LuckPrefix<dark_gray><st>------------</st>").miniMessage());
            return false;
        }
        switch (args[0]) {
            case "group": {
                return GroupSubCommand.execute(adventurePlayer, args);
            }
            case "reload": {
                return ReloadConfigsSubCommand.execute(adventurePlayer);
            }
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> arguments = new ArrayList<String>(List.of("group", "reload"));
            arguments.removeIf(argument -> !argument.startsWith(args[0]));
            return arguments;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("group")) {
            LuckPerms luckPerms = LuckPrefix.getInstance().getLuckPerms();
            Set groups = luckPerms.getGroupManager().getLoadedGroups();
            ArrayList<String> arguments = new ArrayList<String>();
            groups.forEach(group -> arguments.add(group.getName()));
            arguments.removeIf(argument -> !argument.startsWith(args[1]));
            return arguments;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("group")) {
            ArrayList<String> arguments = new ArrayList<String>(List.of("prefix", "suffix", "tabformat", "chatformat", "sortID", "namecolor"));
            arguments.removeIf(argument -> !argument.startsWith(args[2]));
            return arguments;
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("group")) {
            if (args[2].equalsIgnoreCase("prefix")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set", "clear"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("suffix")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set", "clear"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("tabformat")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("chatformat")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("sortID")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("namecolor")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("set"));
                arguments.removeIf(argument -> !argument.startsWith(args[3]));
                return arguments;
            }
        }
        if (args.length == 5 && args[0].equalsIgnoreCase("group")) {
            if (args[2].equalsIgnoreCase("prefix")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("<text>"));
                arguments.removeIf(argument -> !argument.startsWith(args[4]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("suffix")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("<text>"));
                arguments.removeIf(argument -> !argument.startsWith(args[4]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("tabformat")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("<text>"));
                arguments.removeIf(argument -> !argument.startsWith(args[4]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("chatformat")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("<text>"));
                arguments.removeIf(argument -> !argument.startsWith(args[4]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("sortID")) {
                ArrayList<String> arguments = new ArrayList<String>(List.of("<number>"));
                arguments.removeIf(argument -> !argument.startsWith(args[4]));
                return arguments;
            }
            if (args[2].equalsIgnoreCase("namecolor")) {
                ArrayList<String> colors = new ArrayList<String>();
                for (ChatColor color : ChatColor.values()) {
                    if (!color.isColor() || color.isFormat()) continue;
                    colors.add(color.name().toUpperCase());
                }
                colors.removeIf(argument -> !argument.startsWith(args[4]));
                return colors;
            }
        }
        return Collections.emptyList();
    }
}

