/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ConfigWatcher {
    private final File directoryToWatch;
    private final Set<String> watchedFileNamesLower;
    private final Predicate<Path> onFileChanged;
    private final long debounceMillis;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "LuckPrefix-ConfigWatcher");
        thread.setDaemon(true);
        return thread;
    });
    private final ConcurrentMap<String, Long> lastTriggerByFile = new ConcurrentHashMap<String, Long>();
    private WatchService watchService;
    private Future<?> watchTask;

    public ConfigWatcher(File directoryToWatch, Set<String> watchedFileNames, Predicate<Path> onFileChanged, long debounceMillis) {
        this.directoryToWatch = Objects.requireNonNull(directoryToWatch, "directoryToWatch");
        this.onFileChanged = Objects.requireNonNull(onFileChanged, "onFileChanged");
        this.debounceMillis = Math.max(0L, debounceMillis);
        this.watchedFileNamesLower = Objects.requireNonNull(watchedFileNames, "watchedFileNames").stream().map(s -> s.toLowerCase().trim()).collect(Collectors.toUnmodifiableSet());
    }

    public ConfigWatcher(File directoryToWatch, Predicate<Path> onFileChanged) {
        this(directoryToWatch, Set.of("config.yml", "database.yml", "groups.yml"), onFileChanged, 250L);
    }

    public void start() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.directoryToWatch.toPath().register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        }
        catch (IOException ioException) {
            return;
        }
        this.watchTask = this.executorService.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                WatchKey watchKey;
                try {
                    watchKey = this.watchService.take();
                }
                catch (InterruptedException interrupted) {
                    Thread.currentThread().interrupt();
                    break;
                }
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Path relativePath;
                    String fileNameLower;
                    Object rawContext;
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY && event.kind() != StandardWatchEventKinds.ENTRY_CREATE || !((rawContext = event.context()) instanceof Path) || !this.watchedFileNamesLower.contains(fileNameLower = (relativePath = (Path)rawContext).getFileName().toString().toLowerCase())) continue;
                    long nowMillis = System.currentTimeMillis();
                    Long lastMillis = (Long)this.lastTriggerByFile.get(fileNameLower);
                    if (lastMillis != null && nowMillis - lastMillis < this.debounceMillis) continue;
                    this.lastTriggerByFile.put(fileNameLower, nowMillis);
                    Path absolutePath = this.directoryToWatch.toPath().resolve(relativePath).toAbsolutePath();
                    try {
                        this.onFileChanged.test(absolutePath);
                    }
                    catch (Exception exception) {}
                }
                watchKey.reset();
            }
        });
    }

    public void stop() {
        if (this.watchTask != null) {
            this.watchTask.cancel(true);
        }
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.executorService.shutdownNow();
        this.lastTriggerByFile.clear();
    }
}

