/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import de.eztxm.luckprefix.common.config.AbstractConfig;
import de.eztxm.luckprefix.common.logging.DebugLog;
import java.nio.file.Path;
import java.util.List;

public final class DatabaseConfig
extends AbstractConfig {
    public DatabaseConfig(Path filePath, DebugLog debugLog) {
        super(filePath, debugLog);
        this.getDebugLog().info("DatabaseConfig: constructed for " + String.valueOf(filePath));
    }

    @Override
    protected void defineDefaults() {
        this.getDebugLog().info("DatabaseConfig.defineDefaults: applying");
        this.addDefault("Database.Enabled", false);
        this.addDefault("Database.Type", "SQLITE");
        this.addDefault("Database.SQLite.Path", this.path().getParent().resolve("storage").toString().replace("\\", "/"));
        this.addDefault("Database.SQLite.FileName", "sqlite.db");
        this.addDefault("Database.MariaDB.Host", "localhost");
        this.addDefault("Database.MariaDB.Port", 3306);
        this.addDefault("Database.MariaDB.Database", "luckprefix");
        this.addDefault("Database.MariaDB.User", "luckprefix");
        this.addDefault("Database.MariaDB.Password", "");
        this.addDefault("Database.MongoDB.Host", "localhost");
        this.addDefault("Database.MongoDB.Port", 27017);
        this.addDefault("Database.MongoDB.Database", "luckprefix");
        this.addDefault("Database.MongoDB.User", "luckprefix");
        this.addDefault("Database.MongoDB.Password", "");
        this.saveDefaults();
        this.getDebugLog().debug("DatabaseConfig.defineDefaults: defaults saved");
        this.setComments("Database", List.of("Supported: SQLITE, MARIADB, MONGODB (disable via Enabled=false)"));
        this.saveComments();
        this.getDebugLog().debug("DatabaseConfig.defineDefaults: comments saved");
    }

    public boolean isDatabaseEnabled() {
        boolean value = this.getBoolean("Database.Enabled", false);
        this.getDebugLog().debug("DatabaseConfig.isDatabaseEnabled -> " + value);
        return value;
    }

    public String getDatabaseType() {
        String value = this.getString("Database.Type", "SQLITE");
        this.getDebugLog().debug("DatabaseConfig.getDatabaseType -> " + value);
        return value;
    }

    public String getSqlitePath() {
        String value = this.getString("Database.SQLite.Path", this.path().getParent().resolve("storage").toString().replace("\\", "/"));
        this.getDebugLog().debug("DatabaseConfig.getSqlitePath -> " + value);
        return value;
    }

    public String getSqliteFileName() {
        String value = this.getString("Database.SQLite.FileName", "sqlite.db");
        this.getDebugLog().debug("DatabaseConfig.getSqliteFileName -> " + value);
        return value;
    }

    public String getMariaHost() {
        String value = this.getString("Database.MariaDB.Host", "localhost");
        this.getDebugLog().debug("DatabaseConfig.getMariaHost -> " + value);
        return value;
    }

    public int getMariaPort() {
        int value = this.getInt("Database.MariaDB.Port", 3306);
        this.getDebugLog().debug("DatabaseConfig.getMariaPort -> " + value);
        return value;
    }

    public String getMariaDatabase() {
        String value = this.getString("Database.MariaDB.Database", "luckprefix");
        this.getDebugLog().debug("DatabaseConfig.getMariaDatabase -> " + value);
        return value;
    }

    public String getMariaUser() {
        String value = this.getString("Database.MariaDB.User", "luckprefix");
        this.getDebugLog().debug("DatabaseConfig.getMariaUser -> " + value);
        return value;
    }

    public String getMariaPassword() {
        String value = this.getString("Database.MariaDB.Password", "");
        String masked = value.isEmpty() ? "(empty)" : "******";
        this.getDebugLog().debug("DatabaseConfig.getMariaPassword -> " + masked);
        return value;
    }

    public String getMongoHost() {
        String value = this.getString("Database.MongoDB.Host", "localhost");
        this.getDebugLog().debug("DatabaseConfig.getMongoHost -> " + value);
        return value;
    }

    public int getMongoPort() {
        int value = this.getInt("Database.MongoDB.Port", 27017);
        this.getDebugLog().debug("DatabaseConfig.getMongoPort -> " + value);
        return value;
    }

    public String getMongoDatabase() {
        String value = this.getString("Database.MongoDB.Database", "luckprefix");
        this.getDebugLog().debug("DatabaseConfig.getMongoDatabase -> " + value);
        return value;
    }

    public String getMongoUser() {
        String value = this.getString("Database.MongoDB.User", "luckprefix");
        this.getDebugLog().debug("DatabaseConfig.getMongoUser -> " + value);
        return value;
    }

    public String getMongoPassword() {
        String value = this.getString("Database.MongoDB.Password", "");
        String masked = value.isEmpty() ? "(empty)" : "******";
        this.getDebugLog().debug("DatabaseConfig.getMongoPassword -> " + masked);
        return value;
    }
}

