/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.luckprefix.common.config;

import de.eztxm.luckprefix.common.config.AbstractConfig;
import de.eztxm.luckprefix.common.logging.DebugLog;
import de.eztxm.luckprefix.common.util.Encoder;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;

public final class GroupsConfig
extends AbstractConfig {
    public GroupsConfig(Path filePath, DebugLog debugLog) {
        super(filePath, debugLog);
        this.getDebugLog().info("GroupsConfig: constructed for " + String.valueOf(filePath));
    }

    @Override
    protected void defineDefaults() {
        this.getDebugLog().info("GroupsConfig.defineDefaults: applying defaults");
        this.addDefault("default.Prefix", "<gray>Player");
        this.addDefault("default.Suffix", "");
        this.addDefault("default.Tabformat", "<prefix> <dark_gray>- <gray><player>");
        this.addDefault("default.Chatformat", "<prefix> <dark_gray>- <gray><player> <dark_gray>\u00bb <gray><message>");
        this.addDefault("default.SortID", 999);
        this.addDefault("default.NameColor", "gray");
        this.saveDefaults();
        this.getDebugLog().debug("GroupsConfig.defineDefaults: defaults saved to disk");
        this.setComments("default", List.of("The name of the group"));
        this.setComments("default.Prefix", List.of("Prefix/Suffix/Tabformat/Chatformat use Adventure MiniMessage,", "but legacy '&' color codes are also supported.", "https://docs.advntr.dev/minimessage/format.html"));
        this.setComments("default.SortID", List.of("Sort-ID defines tablist order (1..999). Lower is higher on the list."));
        this.setComments("default.NameColor", List.of("Name color above the player"));
        this.saveComments();
        this.getDebugLog().debug("GroupsConfig.defineDefaults: comments saved");
    }

    public boolean hasGroup(String rawGroupName) {
        String sectionKey = Encoder.key(rawGroupName);
        boolean present = this.contains(sectionKey);
        this.getDebugLog().debug("GroupsConfig.hasGroup: raw='" + rawGroupName + "' key='" + sectionKey + "' present=" + present);
        return present;
    }

    public String getPrefix(String rawGroupName) {
        String path = Encoder.path(rawGroupName, "Prefix");
        String value = this.getString(path, "");
        if (value.isEmpty()) {
            this.getDebugLog().debug("GroupsConfig.getPrefix: missing \u2192 '' @ " + path);
        }
        return value;
    }

    public String getSuffix(String rawGroupName) {
        String path = Encoder.path(rawGroupName, "Suffix");
        String value = this.getString(path, "");
        if (value.isEmpty()) {
            this.getDebugLog().debug("GroupsConfig.getSuffix: missing \u2192 '' @ " + path);
        }
        return value;
    }

    public String getTabFormat(String rawGroupName) {
        String def = "<prefix> <dark_gray>- <gray><player>";
        String path = Encoder.path(rawGroupName, "Tabformat");
        String value = this.getString(path, def);
        if (def.equals(value)) {
            this.getDebugLog().debug("GroupsConfig.getTabFormat: missing \u2192 default @ " + path);
        }
        return value;
    }

    public String getChatFormat(String rawGroupName) {
        String def = "<prefix> <dark_gray>- <gray><player> <dark_gray>\u00bb <gray><message>";
        String path = Encoder.path(rawGroupName, "Chatformat");
        String value = this.getString(path, def);
        if (def.equals(value)) {
            this.getDebugLog().debug("GroupsConfig.getChatFormat: missing \u2192 default @ " + path);
        }
        return value;
    }

    public int getSortId(String rawGroupName) {
        String path = Encoder.path(rawGroupName, "SortID");
        int value = this.getInt(path, 999);
        if (value == 999) {
            this.getDebugLog().debug("GroupsConfig.getSortId: missing \u2192 999 @ " + path);
        }
        return value;
    }

    public String getNameColor(String rawGroupName) {
        String path = Encoder.path(rawGroupName, "NameColor");
        String value = this.getString(path, "gray");
        if ("gray".equalsIgnoreCase(value)) {
            this.getDebugLog().debug("GroupsConfig.getNameColor: missing \u2192 gray @ " + path);
        }
        return value;
    }

    public void setPrefix(String rawGroupName, String value) {
        String path = Encoder.path(rawGroupName, "Prefix");
        this.getDebugLog().info("GroupsConfig.setPrefix: " + path + " = " + value);
        this.set(path, value);
    }

    public void setSuffix(String rawGroupName, String value) {
        String path = Encoder.path(rawGroupName, "Suffix");
        this.getDebugLog().info("GroupsConfig.setSuffix: " + path + " = " + value);
        this.set(path, value);
    }

    public void setTabFormat(String rawGroupName, String value) {
        String path = Encoder.path(rawGroupName, "Tabformat");
        this.getDebugLog().info("GroupsConfig.setTabFormat: " + path + " = " + value);
        this.set(path, value);
    }

    public void setChatFormat(String rawGroupName, String value) {
        String path = Encoder.path(rawGroupName, "Chatformat");
        this.getDebugLog().info("GroupsConfig.setChatFormat: " + path + " = " + value);
        this.set(path, value);
    }

    public void setSortId(String rawGroupName, int sortId) {
        String path = Encoder.path(rawGroupName, "SortID");
        this.getDebugLog().info("GroupsConfig.setSortId: " + path + " = " + sortId);
        this.set(path, sortId);
    }

    public void setNameColor(String rawGroupName, String colorName) {
        String path = Encoder.path(rawGroupName, "NameColor");
        this.getDebugLog().info("GroupsConfig.setNameColor: " + path + " = " + colorName);
        this.set(path, colorName);
    }

    public void ensureGroupDefaults(String rawGroupName, boolean autoAdd, boolean warn, Consumer<String> warnPrint) {
        String sectionKey = Encoder.key(rawGroupName);
        this.getDebugLog().info("GroupsConfig.ensureGroupDefaults: checking '" + rawGroupName + "' (section='" + sectionKey + "')");
        boolean exists = this.contains(sectionKey);
        if (!exists && !autoAdd) {
            String msg = "Group '" + rawGroupName + "' not found \u2014 skipping.";
            this.getDebugLog().warn("GroupsConfig.ensureGroupDefaults: " + msg);
            if (warn && warnPrint != null) {
                warnPrint.accept(msg);
            }
            return;
        }
        if (!exists) {
            this.set(sectionKey, new LinkedHashMap());
            String msg = "groups.yml: group '" + rawGroupName + "' was missing \u2014 creating with defaults.";
            this.getDebugLog().warn("GroupsConfig.ensureGroupDefaults: " + msg);
            if (warn && warnPrint != null) {
                warnPrint.accept(msg);
            }
        }
        this.setIfMissing(Encoder.path(rawGroupName, "Prefix"), "<gray>" + rawGroupName, warn, warnPrint, rawGroupName, "Prefix");
        this.setIfMissing(Encoder.path(rawGroupName, "Suffix"), "", warn, warnPrint, rawGroupName, "Suffix");
        this.setIfMissing(Encoder.path(rawGroupName, "Tabformat"), "<prefix> <dark_gray>- <gray><player>", warn, warnPrint, rawGroupName, "Tabformat");
        this.setIfMissing(Encoder.path(rawGroupName, "Chatformat"), "<prefix> <dark_gray>- <gray><player> <dark_gray>\u00bb <gray><message>", warn, warnPrint, rawGroupName, "Chatformat");
        boolean hasSortId = this.isSet(Encoder.path(rawGroupName, "SortID"));
        if (!hasSortId) {
            this.set(Encoder.path(rawGroupName, "SortID"), 999);
            String msg = "groups.yml: '" + rawGroupName + ".SortID' was missing \u2014 defaulting to 999.";
            this.getDebugLog().warn("GroupsConfig.ensureGroupDefaults: " + msg);
            if (warn && warnPrint != null) {
                warnPrint.accept(msg);
            }
        }
        this.setIfMissing(Encoder.path(rawGroupName, "NameColor"), "gray", warn, warnPrint, rawGroupName, "NameColor");
        this.getDebugLog().info("GroupsConfig.ensureGroupDefaults: ensured for '" + rawGroupName + "'");
    }

    private void setIfMissing(String dottedPath, Object defaultValue, boolean warn, Consumer<String> warnPrint, String groupName, String keyName) {
        boolean present = this.isSet(dottedPath);
        if (present) {
            return;
        }
        this.set(dottedPath, defaultValue);
        String msg = "groups.yml: '" + groupName + "." + keyName + "' was missing \u2014 setting default: " + String.valueOf(defaultValue);
        this.getDebugLog().warn("GroupsConfig.setIfMissing: " + msg);
        if (warn && warnPrint != null) {
            warnPrint.accept(msg);
        }
    }
}

